package com.blueweb.bookmarks.http;

import java.util.Map;

/**
 * @author BlueWeb - 2003
 * <p>
 * Cette interface definit les fonctionnalites d'une commande
 * HTTP au sens de notre architecture (Pattern Command).
 * Le seul service requis est en fait l'implementation de la
 * methode execute().
 * Une commande sera lancee depuis la servlet controleur,
 * puis le resultat post-traite de retour dans la servlet controleur.
 * </p>
 */
public interface IHttpCommand {
	
	/**
	 * <p>
	 * execute une requete cliente transmise par la servlet controleur.
	 * Celle-ci se doit d'alimenter correctement la map d'entree
	 * et doit se charger de serialiser (s'il y a lieu les objets
	 * transmis en sortie (dans outputMap)
	 * </p>
	 * @param inputMap, tableau associatif contenant les objets necessaires a l'execution d ela commande
	 * @param outputMap, tableau associatif contenant les objets retournes au client
	 * @exception CommandAbortedException, si l'execution echoue
	 */
	public void handleRequest(Map inputMap,Map outputMap);

}
