package com.blueweb.bookmarks.http;

import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.rmi.ServerException;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Collection;
import java.util.Properties;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;

/**
 * <p>
 * Cette servlet est le controleur dans notre implementation
 * maison
 * </p>
 * @author BlueWeb - 2003
 * @see javax.servlet.http.HttpServlet
 */
public class MainServlet extends HttpServlet {
	// logger LOG4J
	private static Logger logger = Logger.getLogger(MainServlet.class);
	
	// une map contenant les commandes possibles
	// cette structure permet a la servlet de tout ignorer des
	// commandes qu'elle va executer.
	// ceci permet d'ecrire du code generique
	private Properties commandsMap;

	// le contexte d'execution de la servlet
	private ServletContext servletContext;

	//  private TarifFacadeHome tarifFacadeHome;

	/**
	 * <p>
	 * This is the classic init method.Exceuted just once.After 
	 * classloader loads this class.
	 * All servlets init work should be placed here.
	 * @see javax.servlet.http.HttpServlet#init()
	 */
	public void init(ServletConfig aConfig) throws ServletException {
		// toujours invoquer la methode de la  classe mere...
		super.init(aConfig); 
		
		// recupere le contexte d'execution
		servletContext = aConfig.getServletContext();
		try {
			// charge depuis le .war le fichier contenant les commandes
			String mapping_file = aConfig.getInitParameter("commands.file");
			logger.debug("mapping file = " + mapping_file);
			
			// initialise notre objet Properties
			commandsMap = new Properties();
			try {
				commandsMap.load(
					servletContext.getResourceAsStream(mapping_file));
				logger.debug(
					"Le fichier contient  = " + commandsMap.size() + " commandes HTTP ");

			} catch (Exception e) {
				// oops cela c'est mal pass...
				// le niveau fatal est bien choisi ici...
				logger.fatal("unable to access the properties file",e);
			}
			// une petite trace pourla route
			logger.debug("fetched resource file..");
			/**
			logger.info("fetching JNDI ref to = ejb/TarifFacade");
			tarifFacadeHome =
				(TarifFacadeHome) JNDIFactory.getInstance().lookup(
					"ejb/TarifFacade",
					TarifFacadeHome.class);
					*/
		} catch (Exception e) {
			e.printStackTrace();
		}
	} // init() 

	/**
	 * <p>
	 * small utility method checking that this class name is a real HttpCommand
	 * </p>
	 * @param aClassName, full name of the class to be checked
	 * @return boolean, true if OK false otherwise
	 */
	private static boolean checkClass(final String aClassName) {
		Class command = null;
		try {
			command = Class.forName(aClassName);
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
		return (IHttpCommand.class.isAssignableFrom(command));
	} // checkClass()

	public void doPost(
		HttpServletRequest aRequest,
		HttpServletResponse aResponse)
		throws ServletException {
		PrintWriter writer = null;
		try {

			// extraie la commande....
			String command_name = aRequest.getParameter("COMMAND");
			logger.info("user requested command = " + command_name);
			commandsMap.list(System.out);
			if (!commandsMap.containsKey(command_name)) {
				throw new ServletException("Unhandled command");
			}

			// le nom de la commande est OK...

			boolean is_real_command =
				checkClass((String) commandsMap.get(command_name));
			logger.info("command checked OK ? = " + is_real_command);
			// lance l'execution
			if (is_real_command) {
				Map input_map = new HashMap();
				input_map.put("tariffacadehome", tarifFacadeHome);
				// extraie tous les parametres sauf le nom de la commande (inutile)
				for (Iterator iter =
					aRequest.getParameterMap().entrySet().iterator();
					iter.hasNext();
					) {
					Map.Entry entry = (Map.Entry) iter.next();
					if (!((String) entry.getKey()).equals(command_name)) {
						// strange but the map holds an array of strings as the value
						// so take the first one...
						String value = ((String[]) entry.getValue())[0];
						input_map.put(entry.getKey(), value);
					}
				}
				logger.info(
					"extracted an input map from size = " + input_map.size());
				IHttpCommand command = null;
				try {

					// should be fastened by a POOL
					// but simple optimization
					// TODO later
					command =
						(IHttpCommand) Class
							.forName((String) commandsMap.get(command_name))
							.newInstance();
				} finally {
					// should allways  be OK!!!
					// already checked for class existenz!!
				}
				command.handleRequest(input_map, new HashMap(), servletContext);
				writer = aResponse.getWriter();
				writer.write("managed");

				writer.close();
			} else {
				throw new ServletException("BAd config file");
			}
		} catch (Exception e) {
			logger.debug("received exception = " + e.getMessage());
			e.printStackTrace();
			throw new ServletException("Unable to handle erequest");
		}

	} // doPost()
	/**
	 * <p>
	 * Handles different GET requests
	 * </p>
	 */
	public void doGet(
		HttpServletRequest aRequest,
		HttpServletResponse aResponse)
		throws ServletException {
		doGet(aRequest, aResponse);

	} // doGet()

}
