package com.blueweb.bookmarks.tools;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

/**
 *<p>
 * Ce composant permet de tester la validit d'une URL.
 * Bien sur la validite des tests qu'il effectue depend
 * essentiellement de la regexp, donc plus celle-ci sera
 *  complete, meilleures seront ses reponses.
 * </p>
 * <p>
 * Notre composant est tres simple et ne propose qu'un seul service
 * isValidURL()
 * </p>
 * @author BlueWeb - 2003/01
 */
public class UrlTester {
	// compiler et matcher puis le Pattern deduit...
	private static Perl5Compiler compiler;
	private static Perl5Matcher matcher;
	private static Pattern pattern;
	
	// la regexp magique!!!
	private final static String REGEXP = "(^(http|ftp|https|file)://)?(\\S+\\.)+(net|org|fr|uk|com|de)(/(\\S)+)?";

	// utilise un bloc statique pour l'initialisation des
	// matcher et compiler
	static{
		compiler = new Perl5Compiler();
		matcher = new Perl5Matcher();
		try{
			pattern = compiler.compile(REGEXP);
		}
		 // oops quelqu'un a touche a la string REGEXP
		 // inutile de continuer , jette une RuntimeException		
		 catch(MalformedPatternException e){
			throw new RuntimeException("Bad Pattern for URL testing");
		}
	}
	
	/**
	 * <p>
	 * Teste une URL (anURL) contre la regexp gnrale
	 * </p>
	 * @param anURL, String contenant l'URLa tester
	 * @return true, si l'URL est valide, false autrement
	 */
	public static boolean isValidURL(String anURL){
		return (matcher.matches(anURL,pattern));
	} // isValidURL()
}
