package com.blueweb.bookmarks.tools;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 *<p>
 * La classe  de test attache  la classe UrlTester.
 * Ici l'importance des noms de classe prend tout son sens
 * puisque l'on voit a quel point UrlTester est un nom mal choisi.
 * On utilise le framework JUnit.
 * </p>
 */
public class UrlTesterTest extends TestCase {

	// rien a faire dans notre cas
	// mais c'est ici que l'on pourait ouvrir un fichier ou une connexion 
	// BDD utilisee dans notre test
	protected void setUp(){
	} // setUp()
	
	// rien a faire ici
	// mais c'est ici que l'on pourait fermer un fichier ou une connexion 
	// BDD utilisee dans notre test
	protected void tearDown(){
	} // tearDown()

	/**
	 * <p>
	 * ce constructeur permet d'afficher quel test echoue
	 * </p>
	 */
	public UrlTesterTest(String aName){
		super(aName);
	}//constructor()
	
	/**
	 * <p>
	 * c'est la methode permettant de tester le seul service
	 * de notre classe UrlTester
	 * attention au nom!!
	 * </p>
	 */
	public void testIsValidURL(){
		assertEquals(UrlTester.isValidURL("http://www.kernel.org"),true);
	} // testIsValidURL()
	
	/**
	 * <p>
	 * construit la suite de tests a derouler...
	 * ici on utilise la methode basee sur l'introspection Java
	 * sympa pour les faineants...
	 * </p>
	 */
	public static Test suite(){
		return new TestSuite(UrlTesterTest.class);
	} // suite()
}