package com.blueweb.test.castor;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

/**
 * @author BlueWeb - 2003
 * <p>
 * Une classe testant Castor.
 * Ce test reste trs simple intentionnellement.
 * Utilise la premiere forme de serialisation/deserialisation possible:
 * celle basee sur l'introspection Java (donc pas de fichier de mapping).
 * On notera le fait que Castor depende de xerces (xmlAPI.jar et xercesImpl.jar)
 * </p>
 */
public class MarshalUnmarshalClass {

	/**
	 * <p>
	 * ignore les exceptions, dans ce contexte d'un petit bout de code de test.
	 * </p>
	 */	
	public static void main(String[] args) throws IOException, IOException, MarshalException, MarshalException, ValidationException {
		// cree Toto, qui vient d'avoir 18 ns...
		DummyClass test_object = new DummyClass();
		test_object.setAge(18);
		test_object.setName("toto");
		
		// pour feter cela on va sauvegarder ces informations 
		// dans un fichier XML (c\temp\castor-out.xml)
		Writer writer = new FileWriter("c:\\temp\\castor-out.xml");
		Marshaller marshaller = new Marshaller(writer);
		marshaller.marshal(test_object);
		writer.close();
		
		// on va quand meme s'assurer que l'objet a ete bien sauvegarde
		Reader reader = new FileReader("c:\\temp\\castor-out.xml");
		// on peut remarquer ici le raccourci d'ecriture DummyClass.class
		Unmarshaller unmarshaller = new Unmarshaller(DummyClass.class);
		DummyClass read_object = (DummyClass)unmarshaller.unmarshal(reader);
		System.err.println("Objet lu a un nom = " + read_object.getName() + " et un age =" + read_object.getAge());
		

	}
}
