package com.blueweb.test.castor;

import java.lang.reflect.Method;

/**
 * @author J.MOLIERE - 2003/01
 * <p>
 * Une  classe mettant en oeuvre l'introspection en Java.
 * Donne  titre informatif , elle ne fait pas grand chose de 
 * spectaculaire et ne montre pas toutes les possibilits de ce
 * package
 * </p>
 */
public class TestIntrospection {
	static class Base{
		public void foo(){
			System.err.println("Base::foo");
		}
	}
	
	static class Heritiere extends Base{
		public void foo(){
			System.err.println("Heritee:foo");
		}
	}
	
	/**
	 * <p>
	 * methode main..
	 * ne s'occupe pas des exceptions..
	 * </p>
	 */
	public static void main(String[] args) throws Exception{
		// on va utiliser la meta classe Class pour :
		// instancier dynamiquement un objet
		// appeller un service sur cet objet
		// recuperer et afficher sa super classe
		Class dyn_class = Heritiere.class;
		// on demande a cette instance de nous donner sa classe
		// mere
		Class super_class = dyn_class.getSuperclass();
		// affiche dans la console la super classe de la classe
		// heritiere
		System.err.println("Super classe = " + super_class.getName());
		// instancie la classe heritiere
		// puis appelle la methode foo()
		// c'est une invocation classique regit par le compilateur
		Heritiere obj_instance = (Heritiere)dyn_class.newInstance();
		obj_instance.foo();
		// invoque foo() dynamiquement
		// la methode foo n'a pas de parametres
		// d'ou le null
		// cf javadoc...
		// attention ici aucun garde-fou
		// le compilateur ne peut vous protger
		Method method_foo =  dyn_class.getDeclaredMethod("foo",null);
		method_foo.invoke( dyn_class.newInstance(),null);
				
		
	}
}
