package com.blueweb.test.castor;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;

import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;

/**
 * @author BlueWeb
 * <p>
 * Utilise un fichier de mapping pour guider la transformation
 * Castor.
 * Ici il est impratif de manipuler les variables d'instance.
 * </p>
 */
public class UtilisationMapping {
	private final static String OUT_FILE= "c:\\temp\\out-castor-2.xml";
	private final static String MAPPING_FILE ="c:\\temp\\mapping.xml";
	public static void main(String[] args) throws Exception {
		// toto a toujours 18ans
		DummyClass toto = new DummyClass();
		toto.setName("toto");
		toto.setAge( 18);
		
		// on sauvegarde....
		Writer writer = new FileWriter(OUT_FILE);
		Marshaller marshaller = new Marshaller(writer);
	    // ici on charge un fichier de mapping
		Mapping mapping_file = new Mapping();
		mapping_file.loadMapping(MAPPING_FILE);
		marshaller.setMapping(mapping_file);
		
		// puis on serialise
		marshaller.marshal(toto);
		
		
		// on teste si cela a fonctionne
		Reader reader = new FileReader(OUT_FILE);
		Unmarshaller unmarshaller = new Unmarshaller(DummyClass.class);
		unmarshaller.setMapping(mapping_file);
		try{
			Object obj_from_stream = unmarshaller.unmarshal(reader);
			System.err.println("Classe de l'objet lu = " + obj_from_stream.getClass().getName());
			DummyClass read_object =(DummyClass)obj_from_stream;
			System.err.println("Nom de l'objet lu = " +read_object.getName()+ " Age = " + read_object.getAge() );
		}
		catch(Exception e){
			e.printStackTrace();
		}
	}
}
