package test.log4j;

// les imports necessaires a notre programme
// ici reduits a nos dependances envers LOG4J
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/**
 * @author Jerome Moliere - 2003
 * <p>
 * Une petite classe demontrant l'utilisation basique de log4j
 * </p>
 */
public class Log4jExemple {

	/**
	 * <p>
	 * la traditionelle methode main()
	 * </p>
	 */
	public static void main(String[] args) {
		// configure avec les options par defaut le systeme de logs
		// il faut un des configurator 1 fois par application 
		// attention ceci n'a pas besoin d'etre fait une fois par classe
		BasicConfigurator.configure();		
		// obtient un Logger
		Logger logger = Logger.getLogger(Log4jExemple.class);
		// peut aussi etre obtenu par le passage du nom du package
		// Logger logger = Logger.getLogger("test.log4j");
		
		// ajuste le niveau desire
		// ici on selectionne le niveau WARN
		// donc tous les messages de niveau DEBUG et INFO seront
		// abandonnes
		logger.setLevel(Level.WARN);
		
		// positionne 2 traces qui ne seront pas affiches
		// dans l'appender par defaut (la console)
		logger.debug("on ne doit pas voir ce message");
		logger.info("celui ci non plus!!");
		
		// celle -ci doit etre affichee
		logger.warn("par contre celui la doit etre affiche");
		
		// fait qqch
		
		// on s'en va alors on salue...
		// l'utilisation d'un niveau FATAL pour cela 
		// est un peu abusive ...
		logger.fatal("au revoir!!");
	}
}
