package test.log4j;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

/**
 * @author J.MOLIERE - 2003
 * <p>
 * Usage un peu plus  avance de log4j via un fichier de 
 * configuration et donc le configurator associe (PropertyConfigurator).
 * </p>
 */
public class Log4jExempleAvance {
	private static Logger logger = Logger.getLogger(Log4jExempleAvance.class);
	private static class Toto{
		public void foo(){
			// faire qqch d'utile !!!
		}	
	}
	
	/**
	 * <p>
	 * La methode main sera appelee avec un argument (nom du fichier
	 * de configuration utilise pour les logs)
	 * </p>
	 */
	public static void main(String[] args) {
		// teste que l'on ait bien saisi un nom de fichier (un argument)
		if(args.length <1){
			usage();
		}
		PropertyConfigurator.configure( args[0]);
		Toto toto = new Toto();
		logger.debug("toto instancie");
		toto.foo();	
		logger.info("foo() invoquee");
		
		logger.warn("fini!!");
	} // main()
	
	private static void usage(){
		System.err.println("Mauvais usage!!");
		System.err.println("java test.log4j.Log4jExempleAvance <fichier de configuration");
		System.exit(255);
	} // usage()
}
