package commons.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

/**
 * <p>
 * Cet exemple va creer des groupes d'options mutuellement exclusives
 * ainsi dans le cas d'utilisation d'un utilitaire d'archivage
 * on va chercher a compresser ou decompresser mais pas dans les 2 en meme temps
 * </p>
 * @author jerome@javaxpert.com
 *
 */
public class AdvancedCliExample {

	public static void main(String[] args) throws ParseException {
		Option compress= new Option("c",false,"compress the given file");
		Option uncompress= new Option("x",false,"uncompress the given file");
		OptionGroup group=new OptionGroup();
		group.addOption(compress);
		group.addOption(uncompress);
		Options opts= new Options();
		opts.addOptionGroup(group);
		CommandLineParser parser = new GnuParser();
		CommandLine line=parser.parse(opts,args);
		if(line.hasOption("c")){
			System.out.println(" compression demandee");
		}
		if(line.hasOption("x")){
			System.out.println("decompression...");
		}
	} //main()
}
