package commons.cli;

import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
//import org.apache.commons.cli.PosixParser;

/**
 * <p>
 * Une classe dmontrant l'utilisation de la librairie Commons Cli.
 * Ici nous gerons peu d'options avec un style de parsing du type GNU de
 * maniere a supporter des noms longs d'options...
 * </p>
 * @author jerome
 *
 */
public class CliExemple {

	public static void main(String[] args) {
		Options options= new Options();
		Option help = new Option( "h","help",false, "print this message" );
		Option exit= new Option("x","exit",false,"exit the application");
		OptionBuilder.withArgName("file");
		OptionBuilder.hasArg();
		OptionBuilder.withDescription("specify the config file to be used");
		OptionBuilder.isRequired(false);
		OptionBuilder.withLongOpt("config");
		Option config= OptionBuilder.create("c");
		options.addOption(config);
		options.addOption(help);
		
		CommandLineParser parser = new BasicParser();
    try {
        // parse the command line arguments
        CommandLine line = parser.parse( options, args );
        // help demandee !!!
        // utile le formatteur integre (HelpFormatter)
        if (line.hasOption("h")){
        	HelpFormatter formatter = new HelpFormatter();
        	formatter.printHelp( "CliExemple", options );
        }
        // a t'on donne un fichier de config en param ?
        if(line.hasOption("c")){
        	// il semble que oui...
        	// quel est ce fichier ?
        	System.out.println("fais qqch du fichier de config =" + line.getOptionValue("c"));
        	
        	
        }
        if(line.hasOption("x")){
        	System.out.println("See you next time");
        	System.exit(1);
        }
    }
    catch( ParseException exp ) {
    	
        // oops, something went wrong
        System.err.println( "Parsing failed. Exception is =" + exp.toString() +"  Reason: " + exp.getMessage() );
    }

	}
}
