package commons.collections;

import java.util.Iterator;
import java.util.Map;

import org.apache.commons.collections.LRUMap;

/**
 * <p>
 * Mise en evidence de la puissance des implementations proposees
 * par le projet Commons Collections.
 * Programme de test utilisant une implementation
 * de l'interface java.util.Map propre  ce produit.
 * Il s'agit ici d'experimenter la LRUMap permettant de creer des caches 
 * tels que ceux utilises dans JBOSS et autres serveurs d'applications.
 * @author jerome
 *
 */
public class CollectionsExemple {

	// affiche le contenu d'une Map
	// methode utititaire
	static void displayMap(final Map aMap){
		for (Iterator iter=aMap.entrySet().iterator();iter.hasNext();){
			Map.Entry entry=(Map.Entry)iter.next();
			System.out.println("cle = "+ entry.getKey() + " valeur =" + entry.getValue());
		}
	}
	public static void main(String[] args) {
		String[] KEYS={"coucou","hello","tutu","tata","titi","monde","world","hallo","welt","kiki"};
		// obtenir une reference sur une Map implementee sous forme
		// d'une LRUMapalgorithm. Une fois pleine (ici 10 elements car precisee dans le constructeur)
		// cette structure va evacuer des objets en scrutant les dates de derniere utilisation
		// tres utile pour batir des caches d'objet de taille fixe comme dans le cas de serveurs d'applications 
		Map map = new LRUMap(10);
		// remplis la map
		for(int i=0;i<10;i++){
			map.put(KEYS[i],new Integer(i));
		}
		// accede aux objets de la map
		// tous sauf le dernier element (kiki)
		for(int i=0;i<9;i++){
			map.get(KEYS[i]);
		}
		displayMap(map);
		// on ajoute un element mais la taille maximale est atteinte
		// il faudra supprimer l'element utilise il y a le plus de temps...
		map.put("nouveau","salut Java");
		
		// on affiche la nouvelle Map
		displayMap(map);
	}//main()
}
