package commons.http;

import java.io.IOException;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.PostMethod;


/**
 * <p>
 * invoque une des servlets exemples de Tomcat
 * en utilisant la mthode POST du protocole HTTP
 * </p>
 * @author jerome
 *
 */
public class PostClient {

	public final static String TARGET_URL="http://localhost:8080/servlet/RequestInfoExample";
	public static void main(String[] args) {
		// client HTTP
		// permet d'obtenir de nombreuses infos et de parametrer le dialogue
		// mais utilise ici sans fioritures
		HttpClient client=new HttpClient();
		// ici l'on souhaite communiquer par la mthode POST ete non la mthode GET
		//comme dans l'exemple prcdent
		HttpMethod method=new PostMethod(TARGET_URL);
		try {
			// lance la recuperation de la page
			// attention le caractere oriente reseau de cette demarche
			// implique la gestion de differentes exceptions
			// la methode executeMethod retourne un status de l'invocation
			int status_code=client.executeMethod(method);
			if(status_code!=HttpStatus.SC_OK){
				System.out.println("probleme lors de la tentative d'invocation");
			}
			// ok cela va bien..
			String result_page=method.getResponseBodyAsString();
			System.out.println("Page recue depuis le serveur Web:\n"+ result_page);
		
		} catch (HttpException e) {			
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		finally{
			// libere la connexion
			method.releaseConnection();
		}
	}

}
