package commons.http;

import java.io.IOException;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;

/**
 * <p>
 * Ouvre une connexion HTTP avec une requete de type GET sur la 
 * page d'accueil d'un serveur Web (port par dfaut 80) en local.
 * Affiche le rsultat (page HTML) dans la console...
 * </p>
 * @author jerome
 *
 */
public class SimpleHttpClient {

	public final static String TARGET_URL="http://localhost:80";
	public static void main(String[] args) {
		// client HTTP
		// permet d'obtenir de nombreuses infos et de parametrer le dialogue
		// mais utilise ici sans fioritures
		HttpClient client=new HttpClient();
		HttpMethod method=new GetMethod(TARGET_URL);
		try {
			// lance la recuperation de la page
			// attention le caractere oriente reseau de cette demarche
			// implique la gestion de differentes exceptions
			// la methode executeMethod retourne un status de l'invocation
			int status_code=client.executeMethod(method);
			if(status_code!=HttpStatus.SC_OK){
				System.out.println("probleme lors de la tentative d'invocation");
			}
			// ok cela va bien..
			String result_page=method.getResponseBodyAsString();
			System.out.println("Page recue depuis le serveur Web:\n"+ result_page);
		
		} catch (HttpException e) {			
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		finally{
			// libere la connexion
			method.releaseConnection();
		}
	}
}
