
package commons.http;

import java.io.IOException;

import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.DefaultMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author jerome
 *
 */
public class StandardRetryClient {
	public final static String TARGET_URL="http://localhost:80/";
	public static void main(String[] args) {
		LogFactory factory=LogFactory.getFactory();
		//factory.
		Log log=LogFactory.getLog(StandardRetryClient.class);
		log.debug("debut du programme client");
		HttpClient client=new HttpClient();
		HttpMethod method=new GetMethod(TARGET_URL);
		method.getParams().setParameter(HttpMethodParams.RETRY_HANDLER,new DefaultHttpMethodRetryHandler(5,false));
		try {
			// lance la recuperation de la page
			// attention le caractere oriente reseau de cette demarche
			// implique la gestion de differentes exceptions
			// la methode executeMethod retourne un status de l'invocation
			int status_code=client.executeMethod(method);
			if(status_code!=HttpStatus.SC_OK){
				System.out.println("probleme lors de la tentative d'invocation");
			}
			// ok cela va bien..
			String result_page=method.getResponseBodyAsString();
			System.out.println("Page recue depuis le serveur Web:\n"+ result_page);
		
		} catch (HttpException e) {			
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		// il est indispensable de rendre les ressources
		// acquises donc on utilise a propos le bloc finally
		finally{
			System.out.println("finally..libere la connexion");
			// libere la connexion
			method.releaseConnection();
		}
	}
}
