package commons.primitives;

import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.collections.primitives.IntIterator;
import org.apache.commons.collections.primitives.IntList;

/**
 * <p>
 * Utilisation du package Commons Primitives
 * pour stocker une liste d'entiers. Cette liste d'entiers (1,2,3,....,n)
 * va ensuite tre utilise de manire  raliser la somme des entiers naturels
 * on va retrouver le fameux rsultat du a Gauss : n*(n+1)/2
 * </p>
 * @author jerome@javaxpert.com
 *
 */
public class SommeEntiers {
	//	 fix the number of elements
	private final static int MAX_ELEMENTS=500000;
	public static void main(String[] args) {
		int sum=0;
		// utilisation d'une structure proche d'une liste
		// a la sauce java.util.List
		IntList int_list= new ArrayIntList(MAX_ELEMENTS);
		for(int i=0;i<MAX_ELEMENTS;i++){
			int_list.add(i);
		}
		// Utilisation d'un iterateur proche du java.util.Iterator
		for(IntIterator iter=int_list.iterator();iter.hasNext();){
			sum+=iter.next();
		}
		System.out.println("La somme des N premiers entiers o N = " + MAX_ELEMENTS+ "est ="+ sum +"\nLa formule predit =" + (MAX_ELEMENTS*(MAX_ELEMENTS+1)/2));
	} // main()
}
