package commons.primitives;

import java.util.ArrayList;
import java.util.Iterator;

import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.collections.primitives.IntIterator;
import org.apache.commons.collections.primitives.IntList;

/**
 * <p>
 * mise  l'epreuve des collections dediees aux types
 * primitifs Java du package commons primitives
 * </p>
 * @author jerome@javaxpert.com
 *
 */
public class TestPrimitives {
	// fix the number of elements
	private final static int MAX_ELEMENTS=1500000;
	/**
	 * we ll make an addition of integers stocked in 2 kind of collections
	 * @param args
	 */
	public static void main(String[] args) {
		
		double start=0,stop=0;
		start=System.currentTimeMillis();
		ArrayList default_list=new ArrayList(MAX_ELEMENTS);
		for(int i=0;i<MAX_ELEMENTS;i++){
			default_list.add(new Integer(i));
		}
		stop=System.currentTimeMillis();
		System.out.println("Init of the ArrayList in ms = "+ (stop-start));
		
		start=System.currentTimeMillis();
		IntList int_list= new ArrayIntList(MAX_ELEMENTS);
		for(int i=0;i<MAX_ELEMENTS;i++){
			int_list.add(i);
		}
		stop=System.currentTimeMillis();
		System.out.println("Init of the ArrayIntList in ms = "+ (stop-start));
		
		System.out.println("Utilisation des listes...");
		start=System.currentTimeMillis();
		int sum=0;
		for(Iterator iter=default_list.iterator();iter.hasNext();){
			Integer value=(Integer)iter.next();
			int int_value=value.intValue();
			sum+=int_value;
		}
		stop=System.currentTimeMillis();
		System.out.println("Sum (classic Implementation)elasped time (ms)="+(stop-start)+"\t sum is = "+ sum);
		start=System.currentTimeMillis();
		sum=0;
		for(IntIterator iter=int_list.iterator();iter.hasNext();){
			sum+=iter.next();
		}
		stop=System.currentTimeMillis();
		System.out.println("Sum with Primitives elasped time (ms)="+(stop-start)+"\t sum is = "+ sum);
		
		
	}//main()
}
