/*
 * Decompiled with CFR 0.152.
 */
package ejb;

import ejb.Signet;
import ejb.SignetBeanData;
import ejb.SignetHome;
import ejb.Theme;
import ejb.ThemeBeanData;
import ejb.ThemeHome;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class GestionnaireSignetsBean
implements SessionBean {
    private Map cachedInterfaces;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }

    public void ejbRemove() throws EJBException, RemoteException {
    }

    public void setSessionContext(SessionContext arg0) throws EJBException, RemoteException {
    }

    public void ejbCreate() {
        this.cachedInterfaces = new TreeMap();
    }

    private Object getHomeInterface(String jndiNaming, Class interfaceClassNarrowed) throws Exception {
        if (!this.cachedInterfaces.containsKey(jndiNaming)) {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup(jndiNaming);
            Object interfaceNarrowed = PortableRemoteObject.narrow((Object)ref, (Class)interfaceClassNarrowed);
            this.cachedInterfaces.put(jndiNaming, interfaceNarrowed);
        }
        return this.cachedInterfaces.get(jndiNaming);
    }

    private ThemeHome getThemeHome() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ejb.ThemeHome");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ThemeHome)this.getHomeInterface("java:comp/env/ejb/ThemeBean", clazz);
    }

    private SignetHome getSignetHome() throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("ejb.SignetHome");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (SignetHome)this.getHomeInterface("java:comp/env/ejb/SignetBean", clazz);
    }

    public String[] getThemes() {
        System.err.println("getThemes");
        ArrayList<String> themes_list = new ArrayList<String>(50);
        try {
            Collection all_themes = this.getThemeHome().findAll();
            Iterator iter = all_themes.iterator();
            while (iter.hasNext()) {
                Theme curr_theme = (Theme)iter.next();
                themes_list.add(curr_theme.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return themes_list.toArray(new String[themes_list.size()]);
    }

    private boolean checkThemeExistence(int themeId) {
        try {
            Theme queried = this.getThemeHome().findByPrimaryKey(new Integer(themeId));
        }
        catch (ObjectNotFoundException onfe) {
            if (themeId != 0) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void addTheme(int id, String name, String remark, int parentId) throws Exception {
        System.out.println("---> ajoute theme = " + name);
        if (this.checkThemeExistence(parentId)) {
            try {
                Theme childTheme = this.getThemeHome().create(new Integer(id), name, remark, new Integer(parentId));
            }
            catch (CreateException ce) {
                System.err.println("\n\n\nCreateException catched !");
                ce.printStackTrace();
            }
        } else {
            throw new Exception("Le theme " + parentId + " n'existe pas.");
        }
    }

    public void addSignetUnderTheme(int signetId, int parentId, String name, String remark, String address) throws Exception {
        System.out.println("J'ajoute le signet = " + name + " sous le parent = " + parentId);
        boolean success = false;
        try {
            if (this.checkThemeExistence(parentId)) {
                Signet theme = this.getSignetHome().create(new Integer(signetId), name, new Integer(parentId), address, remark);
                success = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!success) {
            throw new Exception("Le theme parent n'existe pas, ou une erreur a eu lieu dans l'ajout.");
        }
    }

    public void removeAll() {
        System.out.println("Commence le grand menage en base... ");
        Object ctx = null;
        try {
            SignetHome home = this.getSignetHome();
            Collection all_signets = home.findAll();
            Iterator iter = all_signets.iterator();
            while (iter.hasNext()) {
                Signet current_obj = (Signet)iter.next();
                System.out.println("suppression du signet = " + current_obj.getName());
                current_obj.remove();
            }
            ThemeHome theme_home = this.getThemeHome();
            Collection all_themes = theme_home.findAll();
            Iterator iter2 = all_themes.iterator();
            while (iter2.hasNext()) {
                Theme current_obj = (Theme)iter2.next();
                System.out.println("suppression du  theme = " + current_obj.getName());
                current_obj.remove();
            }
            System.out.println("Boulot fini !!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Collection listThemesUnder(int parentId) {
        System.out.println("liste des themes attaches au parent =  " + parentId);
        try {
            ArrayList<ThemeBeanData> list_fetched = new ArrayList<ThemeBeanData>();
            if (this.checkThemeExistence(parentId)) {
                Collection all_themes = this.getThemeHome().findByThemeParent(new Integer(parentId));
                System.out.println("J'ai trouve = " + all_themes.size() + " themes fils...");
                Iterator iter = all_themes.iterator();
                while (iter.hasNext()) {
                    Theme current_obj = (Theme)iter.next();
                    ThemeBeanData data = new ThemeBeanData(current_obj.getId(), current_obj.getName(), current_obj.getRemark(), current_obj.getParent());
                    list_fetched.add(data);
                }
            }
            return list_fetched;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Collection listSignetsUnder(int parentId) {
        System.out.println("liste des signets rattaches au theme id =  " + parentId);
        Object ctx = null;
        try {
            ArrayList<Signet> list_fetched = new ArrayList<Signet>();
            if (this.checkThemeExistence(parentId)) {
                Collection all_signets = this.getSignetHome().findByThemeParent(new Integer(parentId));
                System.out.println("Nombre de signets trouves = " + all_signets.size());
                Iterator iter = all_signets.iterator();
                while (iter.hasNext()) {
                    Signet current_obj = (Signet)iter.next();
                    SignetBeanData data = new SignetBeanData(current_obj.getId(), current_obj.getName(), current_obj.getRemark(), current_obj.getUrl(), current_obj.getParent());
                    list_fetched.add(current_obj);
                }
            }
            return list_fetched;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Collection listUnder(int parentId) {
        Collection start = this.listThemesUnder(parentId);
        start.addAll(this.listSignetsUnder(parentId));
        return start;
    }
}

