package main.client;


import javax.naming.InitialContext;
import java.io.FileInputStream;
import java.util.Properties;

import test.ejb.*;

/**
 * Une classe demontrant comment utiliser
 * un ejb depuis un contexte client
 * @author J.MOLIERE - 2003
 */
class SessionClient {
        /**
         * methode main() demontrant les etapes necessaires a l'invocation d'un service sur un EJB:
         * - Initialise un contexte JNDI
         * - Opere la recherche de notre EJB session
         * - Obtient la home interface
         * - cree un session bean
         * - puis invoque le service de conversion
         */
	public static void main(String[] args){
				try {
				    	// cree un objet Properties
					Properties props = new Properties();
					// charge le fichier jndi.properties
  					props.load( new FileInputStream("jndi.properties"));
  					// utilise ceet objet pour initialiser le contexte JNDI
  					// de recherche
					InitialContext jndiContext = new InitialContext(props);
					System.err.println("Initial context initialized");
					// utile ce contexte pour chercher notre bean session
					// attention a utiliser le bon nom
					ExempleSessionHome home = (ExempleSessionHome)
                                          jndiContext.lookup("ejb/exemple/session");
                                        // utilise la home interface pour obtenir un proxy sur notre
                                        // EJB
					ExempleSessionRemote session = home.create();

					float montant=(float)1000f;
					// procede a la conversion
					float francs=session.euroToFranc(montant);
					System.out.println("Conversion = " + francs);
				}
				catch(Exception x) {
					x.printStackTrace();
				}
			}
}


