package blueweb.client;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import javax.naming.InitialContext;

import blueweb.interfaces.*;

class BlueWebClient extends JFrame {
	JButton btnBuild = new JButton("Build Data");

	public BlueWebClient() {
		setTitle("Loan Data Builder");

		getContentPane().add(btnBuild);

		pack();

		btnBuild.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try {
					InitialContext jndiContext = new InitialContext();
					SignetsManagementHome home = (SignetsManagementHome) jndiContext.lookup("blueweb/SignetsManagement");

					SignetsManagement lm = home.create();
					lm.buildData();

					JOptionPane.showMessageDialog(BlueWebClient.this, "Loans built");
				}
				catch(Exception x) {
					JOptionPane.showMessageDialog(BlueWebClient.this, "Error: "
						+ x.getMessage());
					x.printStackTrace();
				}
			}
		});

		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				dispose();
				System.exit(0);
			}
		});
	}

   public static void main(String[] args) {
	   new BlueWebClient().show();
   }
}


