package blueweb.entity;

import java.rmi.*;
import javax.ejb.*;
import javax.naming.*;
import java.util.*;

import blueweb.interfaces.*;

/**
 * @ejb:bean name="blueweb/Signet"
 *           display-name="un signet"
 *           type="CMP"
 *           view-type="local"
 *           jndi-name="blueweb/Signet"
 *			 schema="Signet"
 * @ejb:interface extends="javax.ejb.EJBLocalObject"
 * @ejb:home extends="javax.ejb.EJBLocalHome"
 * 			 generate="local"
 * @jboss:table-name table-name="Signet_tbl"
 * @jboss:create-table create="true"
 * @jboss:remove-table remove="false"
 **/

abstract public class SignetBean implements EntityBean {
	/**
	* @ejb:persistent-field
	* @ejb:pk-field
	* @ejb:interface-method view-type="local"
	* @jboss:column-name name="Id"
	**/
	abstract public int getId();
	/**
	* @ejb:interface-method view-type="local"
	**/
	abstract public void setId(int v);

	/**
	* @ejb:persistent-field
	* @ejb:interface-method view-type="local"
	* @jboss:column-name name="name"
	**/
	abstract public String getName();
	/**
	* @ejb:interface-method view-type="local"
	**/
	abstract public void setName(String v);



	/**
	* @ejb:persistent-field
	* @ejb:interface-method view-type="local"
	* @jboss:column-name name="remark"
	**/
	abstract public String getRemark();
	/**
	* @ejb:interface-method view-type="local"
	**/
	abstract public void setRemark(String v);


  /**
	* @ejb:interface-method view-type="local"
	* @ejb:relation
	*    name="ThemeSignetRelation"
	*    role-name="SignetHasTheme"
	*    target-role-name="ThemeForSignet"
	* @jboss:relation
	*    fk-column="Theme"
	*    related-pk-field="id"
	
	*/
    public abstract ThemeLocal getTheme();
    /** @ejb:interface-method view-type="local" */
    public abstract void setTheme(ThemeLocal aTheme);

	/**
	* @ejb:create-method view-type="local"
	*/
	public SignetPK ejbCreate(int id)
	  throws EJBException, CreateException
	{
	  setId(id);
	  return null;
	}

	public void ejbPostCreate(int id) { }

	/**
	* unused SessionBean methods
	*/
	public void ejbRemove() throws javax.ejb.RemoveException {}
	public void ejbActivate() {}
	public void ejbPassivate() {}
	public void setSessionContext(SessionContext sc) {}
}


