package blueweb.entity;

import java.rmi.*;
import javax.ejb.*;
import javax.naming.*;
import java.util.Collection;
import blueweb.interfaces.*;


/**
 * @ejb:bean name="blueweb/Theme"
 *           display-name="un theme"
 *           type="CMP"
 *           view-type="local"
 *           jndi-name="blueweb/Theme"
 *			 schema="Theme"
 * @ejb:interface extends="javax.ejb.EJBLocalObject"
 * @ejb:home extends="javax.ejb.EJBLocalHome"
 * 			 generate="local"
 * @jboss:table-name table-name="theme_tbl"
 * @jboss:create-table create="true"
 * @jboss:remove-table remove="false"
 **/

abstract public class ThemeBean implements EntityBean {
	/**
	* @ejb:persistent-field
	* @ejb:pk-field
	* @ejb:interface-method view-type="local"
	* @jboss:column-name name="Id"
	**/
	abstract public int getId();
	/**
	* @ejb:interface-method view-type="local"
	**/
	abstract public void setId(int v);

	/**
	* @ejb:interface-method view-type="local"
	* @ejb:relation
	*    name="ThemeSignetRelation"
	*    role-name="LoansForUser"
	*    target-role-name="UserHasLoans"
	*
	* @jboss:relation
	*    fk-column="Customer"
	*    related-pk-field="id"
	
	abstract public CustomerLocal getCustomer();
	*/

 /**
	* @ejb:interface-method view-type="local"
	* @ejb:relation
	*    name="ThemeSignetRelation"
	*    role-name="ThemeHasSignets"
	*    target-role-name="SignetsForTheme"
	*/
    public abstract Collection getSignets();
	
    /**
     * @ejb:interface-method view-type="local"
     **/
    public abstract void setSignets(Collection someSignets);
    
	/**
	* @ejb:persistent-field
	* @ejb:interface-method view-type="local"
	* @jboss:column-name name="name"
	**/
	abstract public String getName();
	/**
	* @ejb:interface-method view-type="local"
	**/
	abstract public void setName(String aName);

	/**
	* @ejb:create-method view-type="local"
	*/
	public ThemePK ejbCreate(int id)
	  throws EJBException, CreateException
	{
	  setId(id);
	  return null;
	}

	public void ejbPostCreate(int id) { }

	/**
	* unused SessionBean methods
	*/
	public void ejbRemove() throws javax.ejb.RemoveException {}
	public void ejbActivate() {}
	public void ejbPassivate() {}
	public void setSessionContext(SessionContext sc) {}
}


