package test.ejb;

import javax.ejb.*;

/**
 * <p>
 * Un session Bean tres simple. Propose un seul service, le calcul d'une conversion franc vers euro ou euro vers franc.
 * N'a d'utilit que pour montrer la masse de travail requise pour le deploiement d'un EJB.
 * Bien entendu etant donnee la nature simpliste de ce composant il n'a pas d'interactions avec l'exterieur,
 * donc ne necessite pas de dialogue avec d'autres EJB...
 *</p>
 * @ejb.bean         name="ExempleSession"
 *                   description="exemple bean session"
 *                   jndi-name="ejb/exemple/session"
 *                   type="Stateless"
 *
 * @jboss.container-configuration name="Standard Stateless SessionBean"
 *
 *
 * @author  <a href="mailto:jmoliere@nerim.net">jmoliere@nerim.net</a>
 */
public class ExempleSessionBean implements SessionBean {
       private float tauxDeBase = 6.55957f;
    /**
     * Calcul euro vers franc
     *
     * @ejb.interface-method view-type="remote"
     */
    public float euroToFranc(float aConvertir) {
	   System.err.println("conversion de " + aConvertir + " euros vers des francs");
           return aConvertir*tauxDeBase;
    }

    /**
     * Calcul franc vers euro 
     *
     * @ejb.interface-method view-type="remote"
     */
    public float francToEuro(float aConvertir){
            return aConvertir/tauxDeBase;
    }

    /**
     * rien a faire dans le cas de l'activation
     */
    public void ejbActivate() {
    }

    /**
     * rien a faire dans le cas de la passivation
     */
    public void ejbPassivate() {
    }

    /**
     * le contexte est indifferent dans ce cas...
     */
    public void setSessionContext(SessionContext ctx) {
    }

    public void ejbRemove() {
    }

    public void ejbCreate(){
    }

}
