package client;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

import ejb.GestionnaireSignets;
import ejb.GestionnaireSignetsHome;
import ejb.SignetBeanData;
import ejb.ThemeBeanData;

/**
 * classe de test cliente.
 * Se connecte a un serveur JBOSS configur avec les valeurs par dfaut (1099 pourle serveur JNDI)
 * et l'on suppose que ce serveur est sur la mme machine.
 */
public class TestClient {
	/**
	*<p>
	* La classique methode main(). Fait tout le travail.
	* Obtient la reference sur notre EJB session, appelle les mthodes mtier puis affiche les
	* rsultats.
	*</p>
	*/
	public static void main(String[] args) {
		// date de dbut du code
		long date = System.currentTimeMillis();
		Properties env = new Properties();
		env.setProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
		env.setProperty("java.naming.provider.url", "192.168.0.104:1099");
		env.setProperty("java.naming.factory.url.pkgs", "org.jboss.naming");
		try {
			InitialContext jndiContext = new InitialContext(env);
			Object ref = jndiContext.lookup("GestionnaireSignets");
			System.out.println("Got reference");
			GestionnaireSignetsHome manager_home =
				(GestionnaireSignetsHome) PortableRemoteObject.narrow(ref, GestionnaireSignetsHome.class);
			GestionnaireSignets manager = manager_home.create();
			manager.removeAll();
			manager.addTheme(1, "titi", "un fils rattache a la racine", 0);
			System.out.println(manager.getThemes().length);	
			manager.addTheme(2, " fils de titi", "un fils non rattache a la racine", 1);
			String[] themes_list = manager.getThemes();
			for (int i = 0; i < themes_list.length; i++) {
				System.out.println("theme found = " + themes_list[i]);
			}
			System.out.println("Adding signet ");
			manager.addSignetUnderTheme(1, 2, "Java", "http://www.javasoft.com/", "main java site");
/*			System.out.println("------------------------------\nListe des enfants du theme titi \n-----------");
			Integer[] children_id = manager.listThemesUnder(1);
			for (int i = 0; i < children_id.length; i++) {
				System.out.println("J'ai trouve un enfant avec l' id = " + children_id[i]);
			}

			System.out.println("------------------------------\nSignets rattachs au thme ID = 2");
			Integer[] signets = manager.listSignetsUnder(2);
			for (int i = 0; i < signets.length; i++) {
				System.out.println("J'ai trouve un enfant avec l' id = " + signets[i]);
			}
*/			
//			System.out.println("On essaie d'ajouter un signet  un parent inexistant");
//			manager.addTheme(10, "mauvais theme", "ce thme ne peut pas tre ajout", 42);

//			System.out.println("On essaie d'ajouter un signet  un parent inexistant");
//			manager.addSignetUnderTheme(1, 42, "msign", "bonne url", "http://www.perdu.com");
		
			System.out.println("On essaie de rcuprer les sous-thmes associs au thme racine");
			Collection col = manager.listUnder(1);
			for(Iterator it = col.iterator(); it.hasNext();) {
				Object current = it.next();
				String text;
				if(current instanceof ThemeBeanData) {
					text = ((ThemeBeanData) current).getName();
				} else {
					text = ((SignetBeanData) current).getName();
				}
				System.out.println(text);
			}
		} catch (Exception e) {
			System.out.println(e.toString());
		}
		
		// calcul de la dure
		System.out.println("Dure : "+(System.currentTimeMillis()-date)+" ms");
	}
}
