package ejb;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

/**
 * Classe gerant la collection de signets...
 * Session bean assurant la facade de notre logique metier avec l'exterieur
 * @author jm
 *
 * @ejb.bean name="GestionnaireSignets" type="Stateless"
 * jndi-name="GestionnaireSignets"
 *
 *
 * @ejb.ejb-ref ejb-name="SignetBean" view-type="local"
 * @ejb.ejb-ref ejb-name="ThemeBean" view-type="local"
 *
 */
public class GestionnaireSignetsBean implements SessionBean {
	/**
	 * Liste des interfaces caches. Elles sont associes  leur nom JNDI.
	 */
	private Map cachedInterfaces;

	/* (non-Javadoc)
	 * @see javax.ejb.SessionBean#ejbActivate()
	 */
	public void ejbActivate() throws EJBException, RemoteException {
	}

	/* (non-Javadoc)
	 * @see javax.ejb.SessionBean#ejbPassivate()
	 */
	public void ejbPassivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.SessionBean#ejbRemove()
	 */
	public void ejbRemove() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.SessionBean#setSessionContext(javax.ejb.SessionContext)
	 */
	public void setSessionContext(SessionContext arg0) throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/**
	*  The ejbCreate method.
	*
	*/
	public void ejbCreate() {
		cachedInterfaces = new TreeMap();
	}

	/**
	 * Retourne l'interface home associe  un nom JNDI. Il est  noter qu'on obtient toujours l'interface locale aprs 
	 * un narrow. Ces interfaces sont par ailleurs caches dans une table (cachedInterfaces).
	 * @param jndiNaming
	 * @param interfaceClassNarrowed
	 * @return
	 * @throws Exception
	 */
	private Object getHomeInterface(String jndiNaming, Class interfaceClassNarrowed) throws Exception {
		if (!cachedInterfaces.containsKey(jndiNaming)) {
			Context ctx = new InitialContext();
			Object ref = ctx.lookup(jndiNaming);
			Object interfaceNarrowed = PortableRemoteObject.narrow(ref, interfaceClassNarrowed);
			cachedInterfaces.put(jndiNaming, interfaceNarrowed);
		}
		return cachedInterfaces.get(jndiNaming);
	}

	/**
	 * Rcupre un objet ThemeHome en effectuant le lookup. Cette mthode facilite la mise en place 
	 * d'un cache d'interfaces.
	 * @return une interface ThemeHome
	 * @throws Exception
	 */
	private ThemeHome getThemeHome() throws Exception {
		return (ThemeHome) getHomeInterface("java:comp/env/ejb/"+ThemeHome.JNDI_NAME, ThemeHome.class);
	}

	/**
	 * Rcupre un objet SignetHome en effectuant le lookup. Cette mthode facilite la mise en place 
	 * d'un cache d'interfaces.
	 * @return une interface ThemeHome
	 * @throws Exception
	 */
	private SignetHome getSignetHome() throws Exception {
		return (SignetHome) getHomeInterface("java:comp/env/ejb/"+SignetHome.JNDI_NAME, SignetHome.class);
	}

	// --------------------------------------------------------
	// Exposed interface
	// --------------------------------------------------------
	/**
	 * Ramene la liste des themes disponibles...
	 *
	 * @return tous les themes disponibles.
	 *
	     * Cette mthode fait partie de l'interface dclare de notre EJB
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Required"
	 */
	public String[] getThemes() {
		System.err.println("getThemes");
		ArrayList themes_list = new ArrayList(50);
		try {
			Collection all_themes = getThemeHome().findAll();
			for (Iterator iter = all_themes.iterator(); iter.hasNext();) {
				Theme curr_theme = (Theme) iter.next();
				themes_list.add(curr_theme.getName());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return (String[]) themes_list.toArray(new String[themes_list.size()]);
	}
	
	/**
	 * Vrifie que le thme existe bien en essayant de le rapatrier et en traitant bien les exceptions.
	 * @param themeId
	 * @return true si le thme existe.
	 */
	private boolean checkThemeExistence(int themeId) {
		Theme queried;
		try {
			// on vrifie que le thme parent existe.
			queried = getThemeHome().findByPrimaryKey(new Integer(themeId));
		} catch(ObjectNotFoundException onfe) {
			// le parent 0 est spcial : c'est la racine. C'est le seul  pouvoir ne pas exister.
			if(themeId!=0)
			{
				return false;
			}
		} catch (Exception e) {
			// elle n'arrive que si le parent n'existe pas.
			e.printStackTrace();
			return false;
		}
		return true;
	}
	
	/**
	 * Ajoute un theme en le rattachant au parent spcifi...
	 * Cette mthode fait partie de l'interface dclare de notre EJB.
	 * Pour qu'on puisse ajouter un thme  un parent, il faut que ce parent existe. Si a n'est pas le cas, une 
	 * exception est retourne.
	* @ejb.interface-method view-type="remote"
	* @ejb.transaction type="Required"
	* @throws Exception si le thme parent n'existe pas.
	*/
	public void addTheme(int id, String name, String remark, int parentId) throws Exception {
		System.out.println("---> ajoute theme = " + name);
		// on ne peut ajouter un enfant que si le parent est non null ou si son id est 0 (auquel cas c'est la racine, et c'est normal).
		if (checkThemeExistence(parentId)) {
			try {
				Theme childTheme = getThemeHome().create(new Integer(id), name, remark, new Integer(parentId));
			} catch (CreateException ce) {
				System.err.println("\n\n\nCreateException catched !");
				ce.printStackTrace();
			}
		} else {
			throw new Exception("Le theme "+parentId+" n'existe pas.");
		}
	} // addTheme

	/**
	* Cette mthode fait partie de l'interface dclare de notre EJB
	* @ejb.interface-method view-type="remote"
	* @ejb.transaction type="Required"
	* @throws Exception si le thme n'existe pas
	*/
	public void addSignetUnderTheme(int signetId, int parentId, String name, String remark, String address) throws Exception {
		System.out.println("J'ajoute le signet = " + name + " sous le parent = " + parentId);
		boolean success = false;
		try {
			// on ne peut ajouter un signet que si le thme parent existe.
			if(checkThemeExistence(parentId)) {
				Signet theme = getSignetHome().create(new Integer(signetId), name, new Integer(parentId), address, remark);
				success = true;
			} else {
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		if(!success) throw new Exception("Le theme parent n'existe pas, ou une erreur a eu lieu dans l'ajout.");
	} //addSignetUnderTheme()

	/**
	* enleve tous les signets et themes...
	* Cette mthode fait partie de l'interface dclare de notre EJB
	* @ejb.interface-method view-type="remote"
	* @ejb.transaction type="Required"
	*/
	public void removeAll() {
		System.out.println("Commence le grand menage en base... ");
		Context ctx = null;
		try {
			SignetHome home = getSignetHome();
			Collection all_signets = home.findAll();

			for (Iterator iter = all_signets.iterator(); iter.hasNext();) {
				Signet current_obj = (Signet) iter.next();
				System.out.println("suppression du signet = " + current_obj.getName());
				current_obj.remove();
			}
			ThemeHome theme_home = getThemeHome();
			Collection all_themes = theme_home.findAll();

			for (Iterator iter = all_themes.iterator(); iter.hasNext();) {
				Theme current_obj = (Theme) iter.next();
				System.out.println("suppression du  theme = " + current_obj.getName());
				current_obj.remove();
			}
			System.out.println("Boulot fini !!");
		} catch (Exception e) {
			e.printStackTrace();
		}

	} // removeAll()
	/**
	 * Liste les themes fils du theme specifie...
	 * @param parentId, id du theme parent...
	 * @return Collection une collection de ThemeBeanData
	 * Cette mthode fait partie de l'interface dclare de notre EJB
	* @ejb.interface-method view-type="remote"
	* @ejb.transaction type="Required"
	*/
	public Collection listThemesUnder(int parentId) {
		System.out.println("liste des themes attaches au parent =  " + parentId);
		try {
			List list_fetched = new ArrayList();
			if(checkThemeExistence(parentId)) {
				Collection all_themes = getThemeHome().findByThemeParent(new Integer(parentId));
				System.out.println("J'ai trouve = " + all_themes.size() + " themes fils...");
				for (Iterator iter = all_themes.iterator(); iter.hasNext();) {
					Theme current_obj = (Theme) iter.next();
					ThemeBeanData data = new ThemeBeanData(current_obj.getId(), current_obj.getName(), current_obj.getRemark(), current_obj.getParent());
					list_fetched.add(data);
				}
			}
			return list_fetched;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	} // listThemesUnder()

	/**
	* Liste les signets attaches au theme specifie...
	* @param parentId, id du theme parent...
	* @return Integer[], tableau contenant les ID des signets trouves
	* Cette mthode fait partie de l'interface dclare de notre EJB
	* @ejb.interface-method view-type="remote"
	* @ejb.transaction type="Required"
	*/
	public Collection listSignetsUnder(int parentId) {
		System.out.println("liste des signets rattaches au theme id =  " + parentId);
		Context ctx = null;
		try {
			List list_fetched = new ArrayList();
			if(checkThemeExistence(parentId)) {
				Collection all_signets = getSignetHome().findByThemeParent(new Integer(parentId));
				System.out.println("Nombre de signets trouves = " + all_signets.size());
				for (Iterator iter = all_signets.iterator(); iter.hasNext();) {
					Signet current_obj = (Signet) iter.next();
					SignetBeanData data = new SignetBeanData(current_obj.getId(), current_obj.getName(), current_obj.getRemark(), current_obj.getUrl(), current_obj.getParent());
					list_fetched.add(current_obj);
				}
			}
			return list_fetched;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	} // listThemesUnder()

	/**
	* @ejb.interface-method view-type="remote"
	* @ejb.transaction type="Required"
	*/
	public Collection listUnder(int parentId) {
		Collection start = listThemesUnder(parentId);
		start.addAll(listSignetsUnder(parentId));
		return start;
	}
}
