package ejb;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;
import javax.ejb.CreateException;

/**
 * Classe refletant un signet dans la BDD.
 * Entity bean de type CMP (gr par le conteneur)
 * @author jm
 *
 * @ejb.bean
 *    type="CMP"
 *    cmp-version="2.x"
 *    name="SignetBean"
 *    schema="Signet"
 *    local-jndi-name="SignetBean"
 *    view-type="local"
 *    primkey-field="id"
 *
 * @ejb.data-object
 *
 * @ejb.pk                  class="java.lang.Integer"
 *
 * @ejb.home generate="local" local-class="ejb.SignetHome"
 * @ejb.interface generate="local" local-class="ejb.Signet"
 *
 * @resin-ejb.entity-bean
 *      sql-table="signet_tbl"
 *
 *
 * @ejb.finder
 *    signature="Signet findByName(java.lang.String name)"
 *    unchecked="true"
 *    query="SELECT OBJECT(signet) FROM Signet signet where signet.name = ?1"
 *    result-type-mapping="Local"
 *
 * @ejb.finder
 *    signature="Collection findByThemeParent(java.lang.Integer parentId)"
 *    unchecked="true"
 *    query="SELECT OBJECT(signet) FROM Signet signet where signet.parent = ?1"
 *    result-type-mapping="Local"
 * @ejb.finder
 *    signature="Collection findAll()"
 *    unchecked="true"
 *    query="SELECT OBJECT(signet) FROM Signet signet"
 *    result-type-mapping="Local"
 *
 * @ejb.persistence
 *      table-name="signet_tbl"
 * @jboss.persistence
 *      create-table="true"
 *      remove-table="true"
 *
 */
public abstract class SignetBean implements EntityBean {
	/**
	  *
	  * @ejb.create-method
	  */
	public Integer ejbCreate(Integer id, String name, Integer parentId, String address, String remark)
		throws CreateException {
		setId(id);
		setName(name);
		setParent(parentId);
		setUrl(address);
		setRemark(remark);
		return null;
	}
	public void ejbPostCreate(Integer id, String name, Integer parentId, String address, String remark)
		throws CreateException {
	}
	// --------------------------------------------------------
	// CMP fields
	// --------------------------------------------------------

	/**
		* @ejb.pk-field
		* @ejb.persistence
		*      column-name="id"
		* @ejb.interface-method
		* @ejb.transaction
		*      type="Supports"
		*/
	public abstract Integer getId();

	public abstract void setId(Integer userId);

	/**
	* @ejb.interface-method view-type="local"
		* @ejb.persistence
		*      column-name="name"
		*      jdbc-type="VARCHAR"
		*      sql-type="varchar(50)"
		*/
	public abstract String getName();

	public abstract void setName(String name);

	/**
	* @ejb.interface-method view-type="local"
		* @ejb.persistence
		*      column-name="remark"
		*      jdbc-type="VARCHAR"
		*      sql-type="varchar(250)"
		*/
	public abstract String getRemark();

	public abstract void setRemark(String remark);

	/**
	* @ejb.interface-method view-type="local"
		* @ejb.persistence
		*      column-name="url"
		*      jdbc-type="VARCHAR"
		*      sql-type="varchar(255)"
		*/
	public abstract String getUrl();

	public abstract void setUrl(String url);

	/**
	* @ejb.interface-method view-type="local"
	* @ejb.persistence
	*      column-name="parent"
	*      jdbc-type="Integer"
	*      sql-type="NUMBER(10)"
	*/

	public abstract Integer getParent();
	public abstract void setParent(Integer id);


	// --------------------------------------------------------
	//
	// --------------------------------------------------------
	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbActivate()
	 */
	public void ejbActivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbLoad()
	 */
	public void ejbLoad() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbPassivate()
	 */
	public void ejbPassivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbRemove()
	 */
	public void ejbRemove() throws RemoveException, EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbStore()
	 */
	public void ejbStore() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext arg0) throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

}
