package ejb;

import java.rmi.RemoteException;
import java.util.Collection;

import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;
import javax.ejb.CreateException;

/**
 * Classe refletant un theme dans la BDD.
 * Entity bean de type CMP (gr par le conteneur)
 * @author jm
 *
 * @ejb.bean
 *    type="CMP"
 *    cmp-version="2.x"
 *    name="ThemeBean"
 *    schema="Theme"
 *    local-jndi-name="ThemeBean"
 *    view-type="local"
 *    primkey-field="id"
 *
 * @ejb.data-object
 *
 * @ejb.pk                  class="java.lang.Integer"
 *
 * @ejb.home generate="local" local-class="ejb.ThemeHome"
 * @ejb.interface generate="local" local-class="ejb.Theme"
 *
 * @ejb.finder
 *    signature="Theme findByThemeName(java.lang.String name)"
 *    unchecked="true"
 *    query="SELECT OBJECT(theme) FROM Theme theme where theme.name = ?1"
 *    result-type-mapping="Local"
 *
 * @ejb.finder
 *    signature="Collection findByThemeParent(java.lang.Integer parentId)"
 *    unchecked="true"
 *    query="SELECT OBJECT(theme) FROM Theme theme where theme.parent = ?1"
 *    result-type-mapping="Local"
 * @ejb.finder
 *    signature="Collection findAll()"
 *    unchecked="true"
 *    query="SELECT OBJECT(theme) FROM Theme theme"
 *    result-type-mapping="Local"
 *
  * @ejb.persistence
 *      table-name="theme_tbl"
 * @jboss.persistence
 *      create-table="true"
 *      remove-table="true"
 *
 */
public abstract class ThemeBean implements EntityBean {
	/**
	  *
	  * @ejb.create-method
	  */
	public Integer ejbCreate(Integer id, String name, String remark, Integer parentId) throws CreateException {
		setId(id);
		setName(name);
		setParent(parentId);
		setRemark(remark);

		return null;
	}
	public void ejbPostCreate(Integer id, String name, String remark, Integer parentId) throws CreateException {
	}
	// --------------------------------------------------------
	// CMP fields
	// --------------------------------------------------------

	/**
		* @ejb.pk-field
		* @ejb.persistence
		*      column-name="id"
		* @ejb.interface-method
		* @ejb.transaction
		*      type="Supports"
		*/
	public abstract Integer getId();

	public abstract void setId(Integer userId);

	/**
	* @ejb.interface-method view-type="local"
		* @ejb.persistence
		*      column-name="name"
		*      jdbc-type="VARCHAR"
		*      sql-type="varchar(50)"
		*/
	public abstract String getName();

	public abstract void setName(String name);

	/**
	* @ejb.interface-method view-type="local"
		* @ejb.persistence
		*      column-name="remark"
		*      jdbc-type="VARCHAR"
		*      sql-type="varchar(255)"
		*/
	public abstract String getRemark();

	public abstract void setRemark(String remark);

	/**
	* @ejb.interface-method view-type="local"
	* @ejb.persistence
	*      column-name="parent"
	*      jdbc-type="Integer"
	*      sql-type="NUMBER(10)"
	*/

	public abstract Integer getParent();
	public abstract void setParent(Integer id);

	/**
	  * @ejb.value-object
	  *   compose="ejb.SignetBeanValue"
	  *   compose-name="Signets"
	  *   members="ejb.Signet"
	  *   members-name="Signet"
	  *   relation="external"
	  *   type=Collection"
	  *  @ejb.interface-method
	  */
	 public abstract Collection getSignets();
	 public abstract void setSignets();

	// --------------------------------------------------------
	//
	// --------------------------------------------------------
	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbActivate()
	 */
	public void ejbActivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbLoad()
	 */
	public void ejbLoad() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbPassivate()
	 */
	public void ejbPassivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbRemove()
	 */
	public void ejbRemove() throws RemoveException, EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#ejbStore()
	 */
	public void ejbStore() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext arg0) throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

}
