EXAMPLES = [
    // Exemples String
    "'hello world'.endsWith('world')",
    "'hello world'.startsWith('hel')",
    "'hello'.isBlank()",
    "''.isBlank()",
    "'   \\t\\r\\n  '.isBlank()",
    "'\"' + '   hello'.trim() + '\"'",
    // Exemples Array
    "[1, 2, 3, 4, 5].sum()",
    "'\"' + ['   ', 'mais', ' comme ', 'a', ' poutre', '\\t'].sum().trim() + '\"'",
    "[10, 15, 20, 25].average()"
];

// LES EXTENSIONS

String.prototype.endsWith = function(suffix) {
    return this.length - suffix.length == this.lastIndexOf(suffix);
};

String.prototype.isBlank = function() {
    return null != this.match(/^\s*$/);
};

String.prototype.startsWith = function(prefix) {
    return 0 == this.indexOf(prefix);
};

String.prototype.trim = function() {
    return this.replace(/^\s+|\s+$/g, '');
};

Array.prototype.inject = function(fx, acc) {
    if (0 == this.length)
        return acc;
    var start = undefined === acc ? 1 : 0;
    if (undefined === acc)
        acc = this[0];
    for (var index = start; index < this.length; ++index)
        acc = fx(acc, this[index]);
    return acc;
} // inject

Array.prototype.sum = function() {
    return this.inject(function(acc, num) {
        return acc + num;
    });
} // sum

Array.prototype.average = function() {
    return this.sum() / this.length;
} // average 

// FIN DES EXTENSIONS

function addListener(element, baseName, handler) {
    if (element.addEventListener)
        element.addEventListener(baseName, handler, false);
    else if (element.attachEvent)
        element.attachEvent('on' + baseName, handler);
} // addListener

function runExample(container, example, useAlternate) {
    var result;
    try {
        result = eval(example);
    } catch (e) {
        result = String(e);
    }
    // Le DOM 2 HTML fournit tout ce qu'il faut en plus simple, mais MSIE a
    // des problmes notoires avec...
    var row = document.createElement('tr');
    if (useAlternate)
        row.className = 'alternate';
    var cell = document.createElement('td');
    cell.appendChild(document.createTextNode(example));
    row.appendChild(cell);
    cell = document.createElement('td');
    cell.appendChild(document.createTextNode(result));
    row.appendChild(cell);
    container.appendChild(row);
} // runExample

function runExamples() {
    var demoContainer = document.getElementById('demos');
    var alternate = true;
    for (var index = 0; index < EXAMPLES.length; ++index)
        runExample(demoContainer, EXAMPLES[index], alternate = !alternate);
} // runExamples

addListener(window, 'load', runExamples);
