/*
 * Exemple d'utilisation de NodeList.
 */

// Compensation pour MSIE...
if ('undefined' == typeof Node)
    Node = { ELEMENT_NODE: 1, TEXT_NODE: 3 };

// Le coeur de l'exemple !

function getInnerText(node) {
	var result = '';
	if (Node.TEXT_NODE == node.nodeType)
		return node.nodeValue;
	if (Node.ELEMENT_NODE != node.nodeType)
		return '';
	for (var index = 0; index < node.childNodes.length; ++index)
		result += getInnerText(node.childNodes.item(index));
	return result;
} // getInnerText

//** Tout le reste sert juste  faire une dmo de getInnerText... **

function demo() {
	var text = getInnerText(document.getElementById('fragmentRoot'));
	var results = document.getElementById('results');
	if (results.hasChildNodes())
		results.firstChild.nodeValue = text;
	else {
		var txt = document.createTextNode(text);
		results.appendChild(txt);
	}
	results.style.display = '';
} // demo

function initButton() {
	var btn = document.getElementById('btnUseNodeList');
	observe(btn, 'click', demo);
} // initButton

function observe(element, event, fx) {
	if (element.addEventListener)
		element.addEventListener(event, fx, false);
	else if (element.attachEvent)
		element.attachEvent('on' + event, fx);
} // observe

observe(window, 'load', initButton);
