CANDIDATES = [
	{ name: 'Marc', grade: 14 },
	{ name: 'Suzanne', grade: 11 },
	{ name: 'Olivier', grade: 15 },
	{ name: 'Amir', grade: 17 },
	{ name: 'Stphane', grade: 13 },
	{ name: 'Julien', grade: 16 },
	{ name: 'Alexis', grade: 18 },
	{ name: 'Aurore', grade: 13 },
	{ name: 'Thomas', grade: 10 },
	{ name: 'Valrie', grade: 18 },
	{ name: 'Adrien', grade: 16 },
	{ name: 'Laurie', grade: 16 },
	{ name: 'William', grade: 13 },
	{ name: 'Charlotte', grade: 15 }
];

function bindButton() {
	Event.observe('btnTest', 'click', extractTop5);
} // bindButton

function extractTop5() {
	$('btnTest').disabled = 'disabled';
	var top5 = get5FirstGoodCandidates(CANDIDATES);
	var list = $('results');
	top5.each(function (c) {
		var item = document.createElement('LI');
		item.appendChild(document.createTextNode(c.name + ' avec ' + c.grade));
		list.appendChild(item);
	});
} // extractTop5

function fillCandidates() {
	var group = $('candidatesList');
	var alternate = true;
	CANDIDATES.each(function (c) {
		alternate = !alternate;
		var row = document.createElement('tr');
		if (alternate)
			row.className = 'alternate';
		var cell = document.createElement('td');
		cell.appendChild(document.createTextNode(c.name));
		row.appendChild(cell);
		cell = document.createElement('td');
		cell.appendChild(document.createTextNode(c.grade));
		row.appendChild(cell);
		group.appendChild(row);
	});
} // fillCandidates

function get5FirstGoodCandidates(candidates) {
	var count = 0;
	var result = [];
	candidates.each(function (c) {
		if (c.grade >= 15) {
			result.push(c);
			if (5 == ++count)
				throw $break;
		}
	});
	return result;
} // get5FirstGoodCandidates

function initPage() {
	bindButton();
	fillCandidates();
	$('btnTest').focus();
} // initPage

Event.observe(window, 'load', initPage);
