#! /usr/bin/env ruby

require 'webrick'
include WEBrick

server = HTTPServer.new(:Port => 8042)
server.mount('/', HTTPServlet::FileHandler, './docroot')

server.mount_proc('/hi') do |request, response|
  response.body = 'Bonjour !'
end

server.mount_proc('/time') do |request, response|
  response.body = Time.now.to_s
end

trap('INT') { server.shutdown }

server.start
