/*
 * Script de l'exemple de rponse XML, version GoogleAJAXSLT
 * (pas de Prototype pour la partie AJAX).
 *
 * Ncessite Prototype 1.4+
 */

function bindButton() {
	Event.observe($('btnProcessFeed'), 'click', processFeed, false);
} // bindButton

function getRequester() {
	var result = false;
/*@cc_on @*/
/*@if (@_jscript_version >= 5)
	try {
		result = new ActiveXObject("Msxml2.XMLHTTP");
	} catch (e) {
		try {
			result = new ActiveXObject("Microsoft.XMLHTTP");
		} catch (E) {
			result = false;
		}
	}
@end @*/
	if (!result && 'undefined' != typeof XMLHttpRequest) {
		try {
			result = new XMLHttpRequest();
		} catch (e) {
			result = false;
		}
	}
	return result;
} // getRequester

function processFeed() {
	var feed = $F('cbxFeed');
	var form = $('feedForm');
	var status = $('status');
	Form.disable(form);
	status.firstChild.nodeValue = '';
	Element.addClassName(status, 'working');
	var requester = getRequester();
	requester.onreadystatechange = function() {
		if (4 == requester.readyState && 200 == requester.status) {
			var data = requester.responseXML;
			logging__ = false;
			var ctx = new ExprContext(data);
			var articleCount = xpathParse('count(//entry)').evaluate(ctx).numberValue();
			Element.removeClassName(status, 'working');
			Form.enable(form);
			status.firstChild.nodeValue = articleCount + ' article(s).';
		}
	};
	var qs = $H({ 'feed': feed }).toQueryString();
	requester.open('GET', '/get_feed?' + qs, true);
	requester.send(null);
} // processFeed

Event.observe(window, 'load', bindButton, false);
