#! /usr/bin/env ruby

require 'webrick'
include WEBrick

STOCKS = [ 'cac40', 'nyse', 'nasdaq' ]
COMMENTS = [ 'actif', 'nerveux', 'calme', 'en folie !' ]

server = HTTPServer.new(:Port => 8042)
server.mount('/', HTTPServlet::FileHandler, './docroot')

server.mount_proc('/stats') do |request, response|
  response['Content-Type'] = 'text/plain'
  response['X-JSON'] = true
  data = '['
  STOCKS.each { |symbol|
  	comment = COMMENTS[rand(COMMENTS.size)]
  	data += "\n\t{ 'symbol': '#{symbol}', 'percent': #{rand(100)}, 'comment': '#{comment}' },"
  }
  data.chop!
  data += "\n]"
  response.body = data
end

trap('INT') { server.shutdown }

srand
server.start
