#! /usr/bin/env ruby

require 'cgi'
require 'erb'
require 'webrick'
include WEBrick

template_text = File.read('suggestions.rhtml')
suggestions = ERB.new(template_text)

server = HTTPServer.new(:Port => 8042)
server.mount('/', HTTPServlet::FileHandler, './docroot')

server.mount_proc('/get_suggestions') do |request, response|
  name_start = CGI::parse(request.body)['library'][0]
  suffix = "/#{Regexp.escape(name_start)}*.rb"
  libs = $LOAD_PATH.map { |dir|
    Dir.glob(dir + suffix, File::FNM_CASEFOLD).map { |f|
	  File.basename(f, '.rb')
	}
  }.flatten.sort.uniq
  response['Content-Type'] = 'text/html'
  response.body = suggestions.result(binding)
end

trap('INT') { server.shutdown }

server.start
