#! /usr/bin/env ruby

require 'cgi'
require 'erb'
require 'webrick'
include WEBrick

template_text = File.read('commentaire.rhtml')
comment = ERB.new(template_text)

server = HTTPServer.new(:Port => 8042)
server.mount('/', HTTPServlet::FileHandler, './docroot')

server.mount_proc('/add_comment') do |request, response|
  post = 'POST' == request.meta_vars['REQUEST_METHOD']
  params = post ? CGI::parse(request.body) : request.query
  params.each { |k, v| params[k] = v[0] } if post
  # PASSEZ les paramtres, sous peine d'erreur de nil
  name = CGI::escapeHTML(params['name'])
  email = CGI::escapeHTML(params['email'])
  # Formatage simple : les textes spars par des lignes vierges
  # sont des paragraphes, et on vire les paragraphes vides.
  text = CGI::escapeHTML(params['comment'])
  text.gsub!(/(\r?\n){2,}/, "</p>\n<p>")
  text = ('<p>' + text + '</p>').gsub(/<p>\s*<\/p>/, '')
  response['Content-Type'] = 'text/html'
  response.body = comment.result(binding)
end

trap('INT') { server.shutdown }

server.start
