<?xml version="1.0" encoding="iso-8859-15"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:template match="/">
    <xsl:apply-templates select="//Items"/>
</xsl:template>
<xsl:template match="Items">
    <xsl:variable name="viewedItems" select="count(Item)"/>
    <xsl:variable name="totalItems" select="TotalResults"/>
    <xsl:choose>
        <xsl:when test="$viewedItems &gt; 0">
            <p class="resultCount">
                <xsl:value-of select="$totalItems"/> r&#233;sultat(s)
                <xsl:if test="$viewedItems &lt; $totalItems">
                    dont <xsl:value-of select="$viewedItems"/> list&#233;s ici.
                </xsl:if>
            </p>
            <dl>
                <xsl:apply-templates select="Item"/>
            </dl>
        </xsl:when>
        <xsl:otherwise>
            <p class="resultCount">Aucun r&#233;sultat&nbsp;!</p>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>
<xsl:template match="Item">
    <dt>
        <xsl:element name="a">
            <xsl:attribute name="href">
                <xsl:value-of select="DetailPageURL"/>
            </xsl:attribute>
            <xsl:value-of select="ItemAttributes/Title"/>
        </xsl:element>
    </dt>
    <dd>
        <xsl:element name="img">
            <xsl:attribute name="class">cover</xsl:attribute>
            <xsl:attribute name="src">
                <xsl:value-of select="MediumImage/URL"/>
            </xsl:attribute>
        </xsl:element>
        <ul>
            <li>
                Auteur(s)&nbsp;:
                <xsl:for-each select="ItemAttributes/Author|ItemAttributes/Creator">
                    <xsl:sort select="@Role"/>
                    <xsl:element name="span">
                        <xsl:attribute name="class">
                            <xsl:choose>
                                <xsl:when test="not(@Role)">author</xsl:when>
                                <xsl:otherwise>contributor</xsl:otherwise>
                            </xsl:choose>
                        </xsl:attribute>
                        <xsl:value-of select="."/>
                        <xsl:if test="@Role"> (<xsl:value-of select="@Role"/>)</xsl:if>
                        <xsl:if test="position() != last()">, </xsl:if>
                    </xsl:element>
                </xsl:for-each>
            </li>
            <li>
                <xsl:value-of select="ItemAttributes/Binding"/>,
                <xsl:value-of select="ItemAttributes/NumberOfPages"/> pages,
                <xsl:value-of select="ItemAttributes/ItemDimensions/Height"/> &times;
                <xsl:value-of select="ItemAttributes/ItemDimensions/Length"/> &times;
                <xsl:value-of select="ItemAttributes/ItemDimensions/Width"/> (cm)
            </li>
            <li>
                Publi&#233; par <xsl:value-of select="ItemAttributes/Publisher"/> le
                <span class="date"><xsl:value-of select="ItemAttributes/PublicationDate"/></span>
            </li>
            <li>ISBN&nbsp;: <xsl:value-of select="ItemAttributes/ISBN"/></li>
            <li>
                Prix &#233;diteur&nbsp;: <span class="price"><xsl:value-of select="ItemAttributes/ListPrice/Amount"/></span>.
                Prix Amazon.fr&nbsp;:
                <xsl:choose>
                    <xsl:when test="OfferSummary/LowestNewPrice">
                        <span class="price"><xsl:value-of select="OfferSummary/LowestNewPrice/Amount"/></span>.
                    </xsl:when>
                    <xsl:when test="OfferSummary/LowestUsedPrice">
                        <span class="price"><xsl:value-of select="OfferSummary/LowestUsedPrice/Amount"/></span>.
                    </xsl:when>
                    <xsl:otherwise>N/D</xsl:otherwise>
                </xsl:choose>
            </li>
    <li>
        <xsl:variable name="availableCount" select="OfferSummary/TotalNew"/>
        <xsl:variable name="usedCount" select="OfferSummary/TotalUsed"/>
        <xsl:choose>
            <xsl:when test="$availableCount &gt; 5">En stock</xsl:when>
            <xsl:when test="$availableCount &gt; 0">
            <xsl:value-of select="$availableCount"/> exemplaire(s) neuf(s)
        </xsl:when>
        <xsl:when test="$usedCount &gt; 0">
            <xsl:value-of select="$usedCount"/> exemplaire(s) d'occasion
        </xsl:when>
        <xsl:otherwise>Ce livre n'est pas en stock actuellement.</xsl:otherwise>
        </xsl:choose>
    </li>
            <li>
                Position dans les ventes&nbsp;:
                <xsl:value-of select="SalesRank"/>
            </li>
        </ul>
    </dd>
</xsl:template>
</xsl:stylesheet>
