/*
 * "Bien Dvelopper pour le Web 2.0", Chapitre 8 : APIs REST.
 *
 * Exemple sur Flickr - Affichage d'un photoset et des photos dtailles.
 *
 * Ncessite Prototype 1.5.0_rc1 ou ultrieur et GoogleAJAXSLT 0.5
 * ou ultrieur.
 */

// Requtes Flickr
FLICKR_API_KEY = 'ca28e9f3c31c44e580f68d39aecf4f3c';
FLICKR_ENDPOINT = 'http://api.flickr.com/services/rest/';
FLICKR_TEMPLATE = new Template(
    FLICKR_ENDPOINT + '?method=flickr.#{method}&api_key=' +
    FLICKR_API_KEY + '#{extraArgs}');

PHOTOSET_ID = 1603279; // Ou 1583292...

// Feuilles XSLT de transformation et architecture de chargement parallle
var gXSLT = {
    _loaded: false,

    sheets: {
        photoset: 'photoset',
        owner: 'photoset_owner',
        photos: 'photoset_photos',
        photo: 'photo'
    },

    load: function(onComplete, expose) {
        if (this._loaded)
            return;
        this._exposeSheets = false !== expose;
        this._onComplete = onComplete;
        this._loadCount = 0;
        this._sheetCount = $A($H(this.sheets).keys()).length;
        for (var s in this.sheets)
            this._loadSheet(s);
    },

    _loadSheet: function(sheet) {
        new Ajax.Request('/xsl/' + this.sheets[sheet] + '.xsl', {
            method: 'get',
            onSuccess: this._sheetLoaded.bind(this, sheet)
        });
    },

    _sheetLoaded: function(sheet, requester) {
        this.sheets[sheet] = xmlParse(requester.responseText);
        if (this._exposeSheets) {
            if (undefined !== this[sheet])
                alert('Cannot expose sheet ' + sheet + ': property exists.');
            this[sheet] = this.sheets[sheet];
        }
        if (++this._loadCount >= this._sheetCount) {
            this._loaded = true;
            (this._onComplete || Prototype.EmptyFunction)();
        }
    }
}; // gXSLT

function adjustTable(html) {
    // La syntaxe $& de String.replace ne marche pas sur Safari...
    html = html.replace(/(<td>(.|\n|\r)*?<\/td>){10}/img, function(s) {
        return '<tr>' + s + '</tr>';
    });
    html = html.replace('<tr><tr>', '<tr>').replace('</tr><td>', '</tr><tr><td>')
        .replace('</tr></tr>', '</tr>');
    return html;
} // adjustTable

function getPhotoset(id) {
    $('results').update('');
    var url = FLICKR_TEMPLATE.evaluate({
        method: 'photosets.getInfo',
        extraArgs: '&photoset_id=' + id
    });
    new Ajax.Request('/xmlProxy', {
        method: 'get',
        parameters: 'url=' + encodeURIComponent(url),
		onLoading: showIndicator,
		onComplete: hideIndicator,
        onSuccess: function(requester) {
            var data = xmlParse(requester.responseText);
            var ctx = new ExprContext(data);
            var ownerNSID = xpathEval('/rsp/photoset/@owner', ctx).stringValue();
            var html = xsltProcess(data, gXSLT.photoset);
            $('results').update(html);
            getOwnerInfo(ownerNSID);
            window.setTimeout('getPhotosetPhotos(' + id + ')', 100);
        }
    });
} // getPhotoset

function getOwnerInfo(nsid) {
    var url = FLICKR_TEMPLATE.evaluate({
        method: 'people.getInfo',
        extraArgs: '&user_id=' + nsid
    });
    new Ajax.Request('/xmlProxy', {
        method: 'get',
        parameters: 'url=' + encodeURIComponent(url),
		onLoading: showIndicator,
		onComplete: hideIndicator,
        onSuccess: function(requester) {
            var data = xmlParse(requester.responseText);
            var html = xsltProcess(data, gXSLT.owner);
            $('photoset-owner').update(html);
        }
    });
} // getOwnerInfo

function getPhotosetPhotos(id) {
    var url = FLICKR_TEMPLATE.evaluate({
        method: 'photosets.getPhotos',
        extraArgs: '&photoset_id=' + id
    });
    new Ajax.Request('/xmlProxy', {
        method: 'get',
        parameters: 'url=' + encodeURIComponent(url),
		onLoading: showIndicator,
		onComplete: hideIndicator,
        onSuccess: function(requester) {
            var data = xmlParse(requester.responseText);
            var html = xsltProcess(data, gXSLT.photos);
            new Insertion.Bottom('results', adjustTable(html));
        }
    });
} // getPhotosetPhotos

function showIndicator() {
	$('indicator').show();
} // showIndicator

function hideIndicator() {
	$('indicator').hide();
} // hideIndicator

function initPage() {
    gXSLT.load(function() {
        getPhotoset(PHOTOSET_ID);
    });
    Event.observe('results', 'click', handleThumbClick);
    Event.observe('photo-closer', 'click', closePhoto);
    new Draggable('photo', {});
} // initPage

function closePhoto(e) {
    Event.stop(e);
    $('photo').hide();
} // closePhoto

function handleThumbClick(e) {
    $('photo').hide();
    Event.stop(e);
    var elt = Event.element(e);
    if (elt.tagName.toLowerCase() != 'img'
        || !Element.childOf(elt, 'photoset-photos'))
        return;
    var url = FLICKR_TEMPLATE.evaluate({
        method: 'photos.getInfo',
        extraArgs: '&photo_id=' + elt.id
    });
    new Ajax.Request('/xmlProxy', {
        method: 'get',
        parameters: 'url=' + encodeURIComponent(url),
		onLoading: showIndicator,
		onComplete: hideIndicator,
        onSuccess: function(requester) {
            var data = xmlParse(requester.responseText);
            var html = xsltProcess(data, gXSLT.photo);
            $('photo-contents').update(html);
            $('photo').show();
        }
    });
} // handleThumbClick

// En cas d'exception, masquer l'indicateur de progression et afficher
// l'exception dans une bote de message.
Ajax.Responders.register({
    onException: function(requester, e) {
        $('indicator').hide();
        alert(e);
    }
});

// viter la console de journalisation de Google AJAXSLT.
logging__ = false;

Event.observe(window, 'load', initPage);
