<?xml version="1.0" encoding="iso-8859-15"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="/">
        <xsl:apply-templates select="/rsp/photo"/>
        <xsl:apply-templates select="/rsp/err"/>
    </xsl:template>
    <xsl:template match="photo">
        <h2><xsl:value-of select="title"/></h2>
        <xsl:element name="img">
            <xsl:attribute name="src">
                http://static.flickr.com/<xsl:value-of select="@server"/>/<xsl:value-of select="@id"/>_<xsl:value-of select="@secret"/>.jpg
            </xsl:attribute>
        </xsl:element>
        <p class="description"><xsl:value-of select="description"/></p>
        <xsl:if test="comments != 0">
            <p class="commentCount">
                <xsl:value-of select="comments"/>
                commentaire<xsl:if test="comments &gt; 1">s</xsl:if>
            </p>
        </xsl:if>
        <xsl:if test="tags/tag">
            <p class="tags">
                &#201;tiquettes&nbsp;:
                <xsl:for-each select="tags/tag">
                    <xsl:value-of select="."/>
                    <xsl:if test="position() != last()">, </xsl:if>
                </xsl:for-each>
            </p>
        </xsl:if>
    </xsl:template>
    <xsl:template match="err">
        <p class="error">
            Erreur n&deg; <xsl:value-of select="@code"/>&nbsp;:
            <xsl:value-of select="@msg"/>
        </p>
    </xsl:template>
</xsl:stylesheet>
