<?xml version="1.0" encoding="iso-8859-15"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="/">
        <xsl:apply-templates select="/rsp/photoset"/>
        <xsl:apply-templates select="/rsp/err"/>
    </xsl:template>
    <xsl:template match="photoset">
        <table id="photoset-photos">
            <tbody>
                <tr>
                    <xsl:apply-templates select="photo"/>
                </tr>
            </tbody>
        </table>
    </xsl:template>
    <xsl:template match="photo">
        <td>
            <xsl:element name="img">
                <xsl:attribute name="id">
                    <xsl:value-of select="@id"/>
                </xsl:attribute>
                <xsl:attribute name="src">
                    http://static.flickr.com/<xsl:value-of select="@server"/>/<xsl:value-of select="@id"/>_<xsl:value-of select="@secret"/>_s.jpg
                </xsl:attribute>
                <xsl:attribute name="alt">
                    <xsl:value-of select="@title"/>
                </xsl:attribute>
                <xsl:attribute name="title">
                    <xsl:value-of select="@title"/>
                </xsl:attribute>
            </xsl:element>
        </td>
    </xsl:template>
    <xsl:template match="err">
        <p class="error">
            Erreur n&deg; <xsl:value-of select="@code"/>&nbsp;:
            <xsl:value-of select="@msg"/>
        </p>
    </xsl:template>
</xsl:stylesheet>
