import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;

public class Articles_indexation {

	String repertoire_index = "/juvenal/lucene/app_livres";
	Analyzer analyseur;
	String expression_recherche = "Hadoop"
    QueryParser parser;
   int resultats_par_page = 10 

// modules d'indexation de contenu 
	private Document createArticles(String contenu, String auteur, String titre, String sujet, String url, Date date_ecriture) {
		Document doc_article = new Document();
		doc_article.add(Field.Text("auteur", auteur));
		doc_article.add(Field.Text("titre", titre));
		doc_article.add(Field.Text("catégorie de l’article", sujet));
		doc_article.add(Field.UnIndexed("lien", url));
		doc_article.add(Field.Keyword("date d’écriture", date_ecriture));
		doc_article.add(Field.UnStored("contenu de l’article", contenu));
		return doc_article;
	}

	private void indexArticles(Document document) throws Exception {
		List<String> StopWords = Arrays.asList("0", "1", "000", "$", "et", "ou") ;
		analyseur = new Analyzer(Version.LUCENE_30, StopWords);
		IndexWriter writer = new IndexWriter (repertoire_index, analyseur, false);
		writer.addDocument(document);
		writer.close();
	}

	public void indexApplication(String article, String author, String title, String topic, String url, Date dateWrite)  throws Exception {
	   Document doc = createArticles(article, author, title, topic, url, dateWrite);
	   indexArticles(doc);
	}

// modules de recherche de contenu 
	public void Searcher() throws IOException{
		IndexSearcher index_cherche = new IndexSearcher(repertoire_index);
		QueryParser parser = new QueryParser("content", analyseur);
		Query query = parser.parse(expression_recherche);
		Hits hits = index_cherche.search(query, resultats_par_page);
		
		for (int i = 0; i<hits.length(); i++) {
			Document doc = hits.doc(i);
			System.out.println((i + 1) + ". " + doc.get("title") + "\t" + 
															  doc.get("author"));
		}   
	   index_cherche.close();
    }
}
