#include <iostream>
#include <cstddef>                      // pour la dfinition de NULL
using namespace std ;


// **************** classe mere ********************************************
class mere
{ public :
   virtual void affiche () = 0 ;   // fonction virtuelle pure
} ;

// ********************* classe liste **************************************
struct element                           // structure d'un lment de liste
{ element * suivant ;                    // pointeur sur l'lment suivant
  void * contenu ;                       // pointeur sur un objet quelconque
} ;

class liste
{ element * debut ;                      // pointeur sur premier lment
  element * courant ;                    // pointeur sur lment courant
 public :
  liste ()                               // constructeur
    { debut = NULL ; courant = debut ; }
  ~liste () ;                            // destructeur
  void ajoute (void *) ;                 // ajoute un lment
  void premier ()                        // positionne sur premier lment
    { courant = debut ;
    }

  void * prochain ()         // fournit ladresse de l'lment courant (0 si fin)
                            // et positionne sur prochain lment (rien si fin)
    { void * adsuiv = NULL ;
      if (courant != NULL){ adsuiv = courant -> contenu ;
                            courant = courant -> suivant ;
                          }
      return adsuiv ;
    }
  void affiche_liste () ;                // affiche tous les lments de la liste
  int fini () { return (courant == NULL) ; }
} ;

liste::~liste ()
{ element * suiv ;
  courant = debut ;
  while (courant != NULL )
   { suiv = courant->suivant ; delete courant ; courant = suiv ; }
}
void liste::ajoute (void * chose)
{ element * adel = new element ;
  adel->suivant = debut ;
  adel->contenu = chose ;
  debut = adel ;
}

void liste::affiche_liste ()
{ mere * ptr ;       // attention, mere * et pas void *
  premier() ;
  while ( ! fini() )
    { ptr = (mere *) prochain() ;
      ptr->affiche () ;
    }
}

// **************** classe point *******************************************
class point : public mere
{ int x, y ;
 public :
  point (int abs=0, int ord=0) { x=abs ; y=ord ; }
  void affiche ()
    { cout << "Point de coordonnees : " << x << " " << y << "\n" ; }
} ;

// **************** classe complexe ****************************************
class complexe : public mere
{ double reel, imag ;
 public :
  complexe (double r=0, double i=0) { reel=r ; imag=i ; }
  void affiche ()
    { cout << "Complexe : " << reel << " + " << imag << "i\n" ; }
} ;

// **************** programme d'essai **************************************
main()
{ liste l ;
  point a(2,3), b(5,9) ;
  complexe x(4.5,2.7), y(2.35,4.86) ;
  l.ajoute (&a) ; l.ajoute (&x) ; l.affiche_liste () ; cout << "--------\n" ;
  l.ajoute (&y) ; l.ajoute (&b) ; l.affiche_liste () ;
}
