-- Ajout colonnes

ALTER TABLE Segment
	ADD (nbSalle NUMBER(2), nbPoste NUMBER(2));
ALTER TABLE Logiciel 
	ADD nbInstall NUMBER(2);
ALTER TABLE Poste 
	ADD nbLog NUMBER(2);

DESC Segment
DESC Logiciel
DESC Poste

SELECT * FROM Segment;
SELECT * FROM Logiciel;
SELECT * FROM Poste;

-- Modif colonnes
ALTER TABLE Salle 
	MODIFY nomSalle VARCHAR2(30);
DESC Salle
SELECT * FROM Salle;

-- tentative :
-- +long 'Brin 2me tage' : 15 caractres
ALTER TABLE Segment 
	MODIFY nomSegment VARCHAR(15);
-- tentative
ALTER TABLE Segment 
	MODIFY nomSegment VARCHAR(14);
DESC Segment
SELECT * FROM Segment;

--Ajout de contraintes

ALTER TABLE Poste 
  ADD CONSTRAINT fk_Poste_indIP_Segment  
  FOREIGN KEY(indIP)
  REFERENCES Segment(indIP);

ALTER TABLE Poste 
  ADD CONSTRAINT fk_Poste_nSalle_Salle
  FOREIGN KEY(nSalle)
  REFERENCES Salle(nSalle);

ALTER TABLE Poste 
  ADD CONSTRAINT fk_Poste_typePoste_Types 
  FOREIGN KEY(typePoste)
  REFERENCES Types(typeLP);

ALTER TABLE Installer
  ADD CONSTRAINT fk_Installer_nPoste_Poste
  FOREIGN KEY(nPoste)
  REFERENCES Poste(nPoste);

ALTER TABLE Installer
  ADD CONSTRAINT fk_Installer_nLog_Logiciel
  FOREIGN KEY(nLog)
  REFERENCES Logiciel(nLog);

--Exceptions

CREATE TABLE Rejets
  (ligne ROWID, propritaire VARCHAR2(30), 
  nomTable VARCHAR2(30), contrainte VARCHAR2(30));

-- commande refuses mais --> enregistrements mauvais dans rejets

ALTER TABLE Logiciel
  ADD CONSTRAINT fk_Logiciel_typeLog_Types 
  FOREIGN KEY(typeLog)
  REFERENCES Types(typeLP)
  EXCEPTIONS INTO Rejets;

ALTER TABLE Salle
  ADD CONSTRAINT fk_Salle_indIP_Segment  
  FOREIGN KEY(indIP)
  REFERENCES Segment(indIP)
  EXCEPTIONS INTO Rejets;

	
SELECT * FROM Rejets;

SELECT ROWID,s.* FROM Salle s
	WHERE ROWID IN (SELECT ligne FROM Rejets) ;

SELECT ROWID,l.* FROM Logiciel l
	WHERE ROWID IN (SELECT ligne FROM Rejets) ;


--rsolution des rejets

--Supprimer les enregistrements de la table Rejets.

DELETE FROM Rejets;

--Supprimer les enregistrements de la table Salle qui posent problme. 

DELETE FROM Salle WHERE indIP NOT IN (SELECT indIP FROM Segment);

--Ajouter le type de logiciel (BeOS, Systme Be)

INSERT INTO Types VALUES ('BeOS','Systme Be');

--Excuter  nouveau lajout des deux contraintes de cl trangre. 
--Vrifier que les instructions ne renvoient plus derreur et que la 
--table Rejets reste vide.


ALTER TABLE Logiciel
  ADD CONSTRAINT fk_Logiciel_typeLog_Types 
  FOREIGN KEY(typeLog)
  REFERENCES Types(typeLP)
  EXCEPTIONS INTO Rejets;

ALTER TABLE Salle
  ADD CONSTRAINT fk_Salle_indIP_Segment  
  FOREIGN KEY(indIP)
  REFERENCES Segment(indIP)
  EXCEPTIONS INTO Rejets;

SELECT * FROM Rejets;



