--WITH

CREATE TABLE Compagnie
	(comp VARCHAR2(4), nomComp VARCHAR2(15),
 	CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

CREATE TABLE Pilote
	(brevet VARCHAR2(6), nom CHAR(20), salaire NUMBER(7,2), compa VARCHAR2(4),
	 CONSTRAINT pk_Pilote PRIMARY KEY(brevet),
	 CONSTRAINT fk_Pil_compa_Comp FOREIGN KEY(compa) REFERENCES Compagnie(comp));

INSERT INTO Compagnie	VALUES ('AF', 'Air France');
INSERT INTO Compagnie   VALUES ('SING', 'Singapore AL');
INSERT INTO Compagnie   VALUES ('CAST', 'Castanet AL');

INSERT INTO Pilote VALUES ('PL-1', 'Henri Alqui', 3400, 'AF');
INSERT INTO Pilote VALUES ('PL-2', 'Pierre Lamothe', 4500, 'AF');
INSERT INTO Pilote VALUES ('PL-3', 'Didier Linxe', 9000, 'AF');
INSERT INTO Pilote VALUES ('PL-4', 'Christian Soutou', 10000, 'SING');
INSERT INTO Pilote VALUES ('PL-5', 'Gilles Laborde', 10050, 'SING');
INSERT INTO Pilote VALUES ('PL-6', 'Pierre Sry', 16000, 'SING');
INSERT INTO Pilote VALUES ('PL-7', 'Michel Castaings', 10000, 'CAST');
INSERT INTO Pilote VALUES ('PL-8', 'Jules Ente', 15000, 'CAST');

WITH comp_charges AS (SELECT nomComp, SUM(salaire) total_sal_comp
 	        	FROM Pilote p, Compagnie c
	 	        WHERE p.compa  = c.comp
			GROUP BY nomComp),
     moy_charges AS (SELECT SUM(total_sal_comp)/COUNT(*) moyenne
  		        FROM comp_charges)

SELECT * 
	FROM comp_charges 
	WHERE total_sal_comp < (SELECT moyenne FROM moy_charges)
	ORDER BY nomComp;

DROP TABLE Pilote;
DROP TABLE Compagnie;


--WITH BUCKET

CREATE TABLE Pilote
	(brevet VARCHAR2(6), nom CHAR(20), nbHVol NUMBER(7,2), compa VARCHAR2(4),
	 CONSTRAINT pk_Pilote PRIMARY KEY(brevet));

INSERT INTO Pilote VALUES ('PL-1', 'Henri Alqui', 400, 'AF');
INSERT INTO Pilote VALUES ('PL-2', 'Pierre Lamothe', 500, 'AF');
INSERT INTO Pilote VALUES ('PL-3', 'Didier Linxe', 900, 'AF');
INSERT INTO Pilote VALUES ('PL-4', 'Christian Soutou', 1000, 'SING');
INSERT INTO Pilote VALUES ('PL-5', 'Gilles Laborde', 1050, 'SING');
INSERT INTO Pilote VALUES ('PL-6', 'Pierre Sry', 1600, 'SING');
INSERT INTO Pilote VALUES ('PL-7', 'Michel Castaings', 1700, 'CAST');
INSERT INTO Pilote VALUES ('PL-8', 'Jules Ente', 4000, 'CAST');
INSERT INTO Pilote VALUES ('PL-9', 'Patrick Baudry', 3999, 'CAST');
INSERT INTO Pilote VALUES ('PL-10', 'Daniel Viel', 5000, 'CAST');


SELECT brevet, nom, nbhvol  FROM Pilote ORDER BY nbHVol ;

SELECT brevet , nom, nbHVol "Heures de vol",
   WIDTH_BUCKET(nbHVol,600, 4000, 10) "Tranche Exprience"
   FROM Pilote
   ORDER BY nbHVol ;

DROP TABLE Pilote;

---WITH rcursif

CREATE TABLE Aeroport
(OACI VARCHAR2(10), nomAero VARCHAR2(30), OACI_resp VARCHAR2(10));

INSERT INTO Aeroport VALUES ('LFPG', 'Paris Charles de Gaule', NULL);
INSERT INTO Aeroport VALUES ('LFPO', 'Paris Orly', 'LFPG');
INSERT INTO Aeroport VALUES ('LFBO', 'Toulouse Blagnac', 'LFBD');
INSERT INTO Aeroport VALUES ('LFBD', 'Bordeaux Merignac', 'LFPO');
INSERT INTO Aeroport VALUES ('LFCI', 'ALbi', 'LFBO');
INSERT INTO Aeroport VALUES ('LFCK', 'Castres', 'LFBO');
INSERT INTO Aeroport VALUES ('LFMW', 'Castelnaudary', 'LFBO');
INSERT INTO Aeroport VALUES ('LFMT', 'Montpellier Fregorgues', 'LFMM');
INSERT INTO Aeroport VALUES ('LFMM', 'Marseille Marignane', 'LFPO');

SELECT OACI,nomAero,OACI_resp FROM Aeroport;

-- hierarchie en dessous de Paris

COL arbo FORMAT A15
WITH
  sous_Paris_Orly (OACI, OACI_resp, niveau) AS
  (
     SELECT OACI, OACI_resp, 0 niveau
     FROM Aeroport 
     WHERE OACI = 'LFPO'
   UNION ALL
     SELECT a.OACI, a.OACI_resp, niveau+1
     FROM sous_Paris_Orly sp, Aeroport a
     WHERE sp.OACI = a.OACI_resp
  )
SELECT OACI_resp, lpad(' ',2*niveau)||OACI arbo, niveau
FROM sous_Paris_Orly 
WHERE niveau>0
ORDER BY niveau, OACI;

-- Liste des descendants

COL OACI FORMAT A5
WITH
  sous_Paris_Orly (OACI, OACI_resp, niveau, aro_liste) AS
  (
     SELECT OACI, OACI_resp, 0 niveau,
        CAST(OACI_resp AS VARCHAR2(25))
     FROM Aeroport 
     WHERE OACI = 'LFPO'
   UNION ALL
     SELECT a.OACI, a.OACI_resp, niveau+1,
        CAST(aro_liste || ',' || a.OACI_resp AS VARCHAR2(25))
     FROM sous_Paris_Orly sp, Aeroport a
     WHERE sp.OACI = a.OACI_resp
  )
SELECT OACI, niveau, aro_liste
FROM sous_Paris_Orly 
ORDER BY niveau, OACI;

-- SEARCH DEPTH FIRST

COL arbo FORMAT A15
WITH
  sous_Paris_Orly (OACI, OACI_resp, niveau) AS
  (
     SELECT OACI, OACI_resp, 0 niveau
     FROM Aeroport 
     WHERE OACI = 'LFPO'
   UNION ALL
     SELECT a.OACI, a.OACI_resp, niveau+1
     FROM sous_Paris_Orly sp, Aeroport a
     WHERE sp.OACI = a.OACI_resp
  )
SEARCH DEPTH FIRST BY OACI_resp SET order1
SELECT OACI_resp, LPAD(' ',2*niveau)||OACI arbo, niveau
FROM sous_Paris_Orly 
WHERE niveau>0
ORDER BY order1;

-- SEARCH BREADTH FIRST BY

COL arbo FORMAT A15
WITH
  sous_Paris_Orly (OACI, OACI_resp, niveau) AS
  (
     SELECT OACI, OACI_resp, 0 niveau
     FROM Aeroport 
     WHERE OACI = 'LFPO'
   UNION ALL
     SELECT a.OACI, a.OACI_resp, niveau+1
     FROM sous_Paris_Orly sp, Aeroport a
     WHERE sp.OACI = a.OACI_resp
  )
SEARCH BREADTH FIRST BY OACI_resp SET order1
SELECT OACI_resp, LPAD(' ',2*niveau)||OACI arbo, niveau
FROM sous_Paris_Orly 
WHERE niveau>0
ORDER BY order1;

DROP TABLE Aeroport;

-- cycles

CREATE TABLE Aeroport
(OACI VARCHAR2(10), nomAero VARCHAR2(30), anneeCreation NUMBER(4),
  OACI_resp VARCHAR2(10));


INSERT INTO Aeroport VALUES ('LFPG', 'Paris Charles de Gaule', 1978, NULL);
INSERT INTO Aeroport VALUES ('LFPO', 'Paris Orly', 1967, 'LFPG');
INSERT INTO Aeroport VALUES ('LFBO', 'Toulouse Blagnac', 1968, 'LFBD');
INSERT INTO Aeroport VALUES ('LFBD', 'Bordeaux Merignac', 1972, 'LFPO');
INSERT INTO Aeroport VALUES ('LFCI', 'ALbi', 1967, 'LFBO');
INSERT INTO Aeroport VALUES ('LFCK', 'Castres', 1980, 'LFBO');
INSERT INTO Aeroport VALUES ('LFMW', 'Castelnaudary', 1981, 'LFBO');
INSERT INTO Aeroport VALUES ('LFMT', 'Montpellier Fregorgues', 1973,'LFMM');
INSERT INTO Aeroport VALUES ('LFMM', 'Marseille Marignane', 1975, 'LFPO');

SELECT OACI,nomAero,OACI_resp,anneeCreation  FROM Aeroport;

-- recherche d'un cycle

COL arbo FORMAT A15
COL est_cycle FORMAT A9
WITH
  sous_Paris_Orly (OACI, OACI_resp, niveau,creation) AS
  (
     SELECT OACI, OACI_resp, 0 niveau, anneeCreation
     FROM Aeroport 
     WHERE OACI = 'LFPO'
   UNION ALL
     SELECT a.OACI, a.OACI_resp, niveau+1, anneeCreation
     FROM sous_Paris_Orly sp, Aeroport a
     WHERE sp.OACI = a.OACI_resp
  )
SEARCH DEPTH FIRST BY OACI_resp SET order1
CYCLE creation SET est_cycle TO 'Y' DEFAULT 'N'
SELECT OACI_resp, LPAD(' ',2*niveau)||OACI arbo, niveau, creation, est_cycle 
FROM sous_Paris_Orly 
ORDER BY order1;

DROP TABLE Aeroport;

-- graphes

CREATE TABLE Autoroutes
(ville_de VARCHAR(16),ville_vers VARCHAR(16), km NUMBER(3));

INSERT INTO Autoroutes VALUES ('PARIS', 'NANTES', 385);
INSERT INTO Autoroutes VALUES ('PARIS', 'CLERMONT-FERRAND', 420);
INSERT INTO Autoroutes VALUES ('PARIS', 'LYON', 470);
INSERT INTO Autoroutes VALUES ('CLERMONT-FERRAND', 'MONTPELLIER', 335);
INSERT INTO Autoroutes VALUES ('CLERMONT-FERRAND', 'TOULOUSE', 375);
INSERT INTO Autoroutes VALUES ('LYON', 'MONTPELLIER', 305);
INSERT INTO Autoroutes VALUES ('LYON', 'MARSEILLE', 320);
INSERT INTO Autoroutes VALUES ('MONTPELLIER', 'TOULOUSE', 240);
INSERT INTO Autoroutes VALUES ('MARSEILLE', 'NICE', 205);

SELECT ville_de, ville_vers, km FROM Autoroutes;

--nombre d'tapes des diffrents trajets, entre Paris et la ville rose

WITH trajets (ville_vers, etape) 
AS
   (SELECT DISTINCT ville_de, 0
      FROM   Autoroutes
      WHERE  ville_de = 'PARIS'
    UNION  ALL
    SELECT  a.ville_vers, t.etape + 1
      FROM  Autoroutes a, trajets t
      WHERE t.ville_vers  = a.ville_de)
SELECT ville_vers, etape
FROM   trajets 
WHERE  ville_vers = 'TOULOUSE';

--nombre de km pour chacun de ces trajets

WITH trajets (ville_vers, etape, distance) 
AS
   (SELECT DISTINCT ville_de, 0, 0
      FROM   Autoroutes
      WHERE  ville_de = 'PARIS'
    UNION  ALL
    SELECT  a.ville_vers, t.etape + 1, t.distance+a.km
      FROM  Autoroutes a, trajets t
      WHERE t.ville_vers  = a.ville_de)
SELECT ville_vers, etape, distance
FROM   trajets 
WHERE  ville_vers = 'TOULOUSE'; 

--dtail des trajets

WITH trajets (ville_vers, etape, distance, trajet) 
AS
   (SELECT DISTINCT ville_de, 0, 0, CAST('PARIS' AS VARCHAR(50))
      FROM   Autoroutes
      WHERE  ville_de = 'PARIS'
    UNION  ALL
    SELECT  a.ville_vers, t.etape + 1, t.distance+a.km, 
         CAST(t.trajet|| ',' || a.ville_vers AS VARCHAR2(50))
      FROM  Autoroutes a, trajets t
      WHERE t.ville_vers  = a.ville_de)
SELECT trajet, etape, distance
FROM   trajets 
WHERE  ville_vers = 'TOULOUSE'
ORDER BY distance;

--graphe orient

--insertion des routes inverses

INSERT INTO Autoroutes
	SELECT ville_vers,ville_de, km FROM Autoroutes;

SELECT ville_de, ville_vers, km 
	FROM Autoroutes ORDER BY ville_de, ville_vers;

--

WITH trajets (ville_vers, etape, distance, trajet) 
AS
   (SELECT DISTINCT ville_de, 0, 0, CAST('PARIS' AS VARCHAR(50))
      FROM   Autoroutes
      WHERE  ville_de = 'PARIS'
    UNION  ALL
    SELECT  a.ville_vers, t.etape + 1, t.distance+a.km, 
         CAST(t.trajet|| ',' || a.ville_vers AS VARCHAR2(50))
      FROM  Autoroutes a, trajets t
      WHERE t.ville_vers  = a.ville_de
      AND  t.trajet NOT LIKE '%' || a.ville_vers || '%'
      AND etape <10)
SELECT trajet, etape, distance
FROM   trajets 
WHERE  ville_vers = 'TOULOUSE'
ORDER BY distance;

DROP TABLE Autoroutes;