
-- Comment retourner une table

CREATE TABLE Pilote
	(brevet VARCHAR2(6), nom CHAR(20), salaire NUMBER(7,2), compa VARCHAR2(4),
	 CONSTRAINT pk_Pilote PRIMARY KEY(brevet));

INSERT INTO Pilote VALUES ('PL-1', 'Henri Alqui', 3400, 'AF');
INSERT INTO Pilote VALUES ('PL-2', 'Pierre Lamothe', 4500, 'AF');
INSERT INTO Pilote VALUES ('PL-3', 'Didier Linxe', 9000, 'AF');
INSERT INTO Pilote VALUES ('PL-4', 'Christian Soutou', 10000, 'SING');
INSERT INTO Pilote VALUES ('PL-5', 'Gilles Laborde', 10050, 'SING');
INSERT INTO Pilote VALUES ('PL-6', 'Pierre Sry', 16000, 'SING');
INSERT INTO Pilote VALUES ('PL-7', 'Michel Castaings', 10000, 'CAST');
INSERT INTO Pilote VALUES ('PL-8', 'Jules Ente', 15000, 'CAST');
COMMIT;

CREATE OR REPLACE PACKAGE PKG_Pilotes
IS
  TYPE Pilote_tytab
	IS TABLE OF Pilote%ROWTYPE INDEX BY BINARY_INTEGER;
  FUNCTION f_pilotes_compagnie (v_comp IN VARCHAR2) RETURN Pilote_tytab;
END PKG_Pilotes;
/

CREATE OR REPLACE PACKAGE BODY PKG_Pilotes
IS
  FUNCTION f_pilotes_compagnie (v_comp IN VARCHAR2) RETURN Pilote_tytab
  IS
     tab Pilote_tytab;
  BEGIN
  SELECT * BULK COLLECT 
      INTO tab FROM Pilote WHERE compa=v_comp;
     RETURN tab;
  END ;
END PKG_Pilotes;
/

SET SERVEROUT ON

DECLARE
    tab_sortie PKG_Pilotes.Pilote_tytab;
    nb_pil NUMBER;
    i NUMBER;
BEGIN
    tab_sortie := PKG_Pilotes.f_pilotes_compagnie('AF');
    nb_pil := tab_sortie.COUNT;
    DBMS_OUTPUT.PUT_LINE('Il y a ' || nb_pil || ' pilote(s).');
    FOR i IN 1..nb_pil LOOP
	 DBMS_OUTPUT.PUT_LINE(tab_sortie(i).nom);
    END LOOP;
END;
/

DROP PACKAGE PKG_Pilotes;
DROP TABLE Pilote;