
--EXPLAIN PLAN

-- sous votre user

start ?\rdbms\admin\utlxplan.sql
-- ? dsigne automatiquement ORACLE_HOME

-- Vision du plan d'execution 

EXPLAIN PLAN
SET STATEMENT_ID = 'exemple1'
FOR
SELECT a.adhid, a.prenom, a.nom 
  FROM Adherent a, Pratique p, Sport s
  WHERE TO_CHAR(DATE_NAIS,'YYYY')='1995'
  AND  a.adhid = p.adhid
  AND  s.spid = p.spid
  AND  s.splibelle = 'Hand-ball'
  ORDER BY nom;

SET LINESIZE 130
SET PAGESIZE 0
SELECT * FROM TABLE
   (DBMS_XPLAN.DISPLAY('PLAN_TABLE','exemple1','TYPICAL',NULL));


-- Vision du plan d'execution en mmoire 

SET LINESIZE 80
DESC V$SQL

SELECT SQL_ID FROM V$SQL WHERE SQL_TEXT LIKE '%Hand-ball%' 
       AND SQL_TEXT LIKE '%TO_CHAR(DATE_NAIS,''YYYY'')%';

DESC V$SQL_PLAN

SELECT ID,OPERATION FROM V$SQL_PLAN 
	WHERE SQL_ID IN (
SELECT SQL_ID FROM V$SQL WHERE SQL_TEXT LIKE '%Hand-ball%' 
       AND SQL_TEXT LIKE '%TO_CHAR(DATE_NAIS,''YYYY'')%');


--exemple graphique avec OEM

SELECT a.adhid, a.prenom, a.nom 
  FROM Adherent a, Pratique p, Sport s
  WHERE TO_CHAR(DATE_NAIS,'YYYY')='1995'
  AND  a.adhid = p.adhid
  AND  s.spid = p.spid
  AND  s.splibelle = 'Hand-ball'
  ORDER BY nom;

SET LINESIZE 130
SET PAGESIZE 0
SELECT * FROM TABLE (DBMS_XPLAN.DISPLAY_CURSOR);
