
--DBMS_INFO

CREATE OR REPLACE PROCEDURE ajoute_sport
 (v_spid NUMBER, v_splibelle VARCHAR) AS
 v_nbrsport NUMBER :=0;
BEGIN
  DBMS_APPLICATION_INFO.SET_CLIENT_INFO(client_info => 'client Web');
  DBMS_APPLICATION_INFO.SET_MODULE(module_name => 'ajoute_sport', action_name => NULL);
-- Transaction
  INSERT INTO Sport (spid, splibelle) VALUES (v_spid, v_splibelle); 
--  COMMIT;
  SELECT COUNT(*) INTO v_nbrsport FROM Sport;
  DBMS_APPLICATION_INFO.SET_ACTION(action_name => 'Nombre de sports : '||v_nbrsport);
--  la fin
--  DBMS_APPLICATION_INFO.SET_MODULE(NULL,NULL);
--  DBMS_APPLICATION_INFO.SET_CLIENT_INFO(NULL);
END;
/

EXEC ajoute_sport (2,'Voltige');
ROLLBACK;

-- infos sur la session

COL module FORMAT A12
COL action FORMAT A21
COL client_info FORMAT A15
SELECT sid, serial#, module, action, client_info
FROM V$SESSION
WHERE sid = (SELECT DISTINCT sid FROM V$MYSTAT)
  AND audsid = SYS_CONTEXT('userenv', 'sessionid');


-- collecte tout ce qui s'est pass au cours de la session

COL sql_text FORMAT A50
SELECT sql_text, module, action
FROM v$sqlarea 
WHERE module = 'ajoute_sport'; 

SELECT SYS_CONTEXT('userenv','module') FROM DUAL;

SELECT SYS_CONTEXT('userenv','action') FROM DUAL;

SELECT SYS_CONTEXT('userenv','client_info') FROM DUAL;

-- modifiez "SOUTOU" par votre nom de user en majuscules

SELECT sid,serial#,client_info,module,action 
      FROM v$SESSION
      WHERE username='SOUTOU';


------Lecture des informations

SET SERVEROUTPUT ON

DECLARE
  v_client_info  VARCHAR2(64);
  v_module      VARCHAR2(48);
  v_action        VARCHAR2(32);
BEGIN
  DBMS_APPLICATION_INFO.READ_MODULE(v_module, v_action);
  DBMS_APPLICATION_INFO.READ_CLIENT_INFO(v_client_info);
  DBMS_OUTPUT.PUT_LINE(v_module||'/'||v_action||'/'||v_client_info);
END;
/

--controle de la concurrence

CREATE OR REPLACE FUNCTION verifie_exec(v_module IN VARCHAR2)
RETURN BOOLEAN IS
  v_nbre INTEGER; 
BEGIN
  SELECT 1 INTO v_nbre FROM V$SESSION
    WHERE module = v_module AND ROWNUM = 1;     
  RETURN(FALSE);
EXCEPTION 
  WHEN NO_DATA_FOUND THEN 
    RETURN(TRUE);
END;
/

CREATE OR REPLACE PROCEDURE p1 IS
BEGIN 
  IF NOT verifie_exec('p2') THEN
    DBMS_OUTPUT.PUT_LINE('p2 est en cours d''execution...');
    RETURN;
  END IF;
  DBMS_APPLICATION_INFO.SET_MODULE('p1','ajout adherent'); 
  -- transaction ajout adherent
  DBMS_APPLICATION_INFO.SET_MODULE(NULL, NULL);
END; 
/

CREATE OR REPLACE PROCEDURE p2 IS
BEGIN 
  IF NOT verifie_exec('p1') THEN
    DBMS_OUTPUT.PUT_LINE('p1 est en cours d''execution...');
    RETURN;
  END IF;
  DBMS_APPLICATION_INFO.SET_MODULE('p2','ajout adherent exterieur'); 
  -- transaction ajout adherent exterieur
  DBMS_APPLICATION_INFO.SET_MODULE(NULL, NULL);
END; 
/

DROP PROCEDURE p1;
DROP PROCEDURE p2;
DROP FUNCTION verifie_exec;
DROP PROCEDURE ajoute_sport;

--- Oprations longues

-- sous SYS AS SYSDBA : 

-- modifiez "soutou" par votre nom de user

GRANT EXECUTE ON DBMS_LOCK TO soutou;

-- sous votre user

SET SERVEROUTPUT ON

DECLARE
 l_rindex NUMBER DEFAULT DBMS_APPLICATION_INFO.SET_SESSION_LONGOPS_NOHINT;
 l_slno NUMBER;
BEGIN
 FOR i IN 1 .. 60 LOOP
  DBMS_OUTPUT.PUT_LINE('On passe a i = '|| i);
   DBMS_LOCK.SLEEP (1);
   DBMS_APPLICATION_INFO.SET_SESSION_LONGOPS(rindex => l_rindex,slno => l_slno,
    op_name => 'test de DBMS_APPLICATION_INFO',target => NULL,target_desc => NULL,
    context => 1,sofar => i,totalwork => 60,units => 'Itrations' );
END LOOP;
END;
/

-- dans une autre session

SELECT OPNAME,TIME_REMAINING,ELAPSED_SECONDS, SOFAR,TOTALWORK, UNITS
       FROM V$SESSION_LONGOPS;

---SQL Monitor
  
--reprer la session 

SELECT sid, serial#, audsid
   FROM v$session
   WHERE audsid=sys_context('USERENV','SESSIONID');

--lancer une requte longue

-- sans les index sur le jeu d'essai...
-- ALTER TABLE Pratique DROP CONSTRAINT pk_Pratique;
-- ALTER TABLE Adherent DROP CONSTRAINT pk_Adherent;
-- ALTER TABLE Sport DROP CONSTRAINT pk_Sport;
-- DROP INDEX idx_Pratique_spid;
-- DROP INDEX idx_Pratique_adhid;

--division : qui font les mmes sport que Boris Grignon...

SELECT DISTINCT a.nom, a.prenom FROM Adherent a
	WHERE NOT EXISTS
	(
        SELECT spid FROM Pratique WHERE adhid = (SELECT adhid FROM Adherent 
         WHERE nom='GRIGNON' AND prenom='BORIS' AND tel='02.31.39.16.61')
	MINUS
	SELECT spid FROM Pratique WHERE adhid = a.adhid
	)
	AND NOT EXISTS
	(
	SELECT spid FROM Pratique WHERE adhid = a.adhid
	MINUS
	SELECT spid FROM Pratique WHERE adhid = (SELECT adhid FROM Adherent 
         WHERE nom='GRIGNON' AND prenom='BORIS' AND tel='02.31.39.16.61')
	);

--dans une autre fentre

COLUMN key FORMAT 999999999999
SET colsep '|'
SELECT key, sql_id, sql_exec_id,
     TO_CHAR(MAX(sql_exec_start),'DD/MM/YYYY HH24:Mi:SS') sql_exec_start,
     sql_child_address child_address
  FROM V$SQL_MONITOR
  WHERE sid=23
  AND session_serial#=6945
  GROUP BY key, sql_id, sql_exec_id, sql_child_address
  ORDER BY sql_exec_start;

--

COL id FORMAT 999
COL operation FORMAT A25
COL object FORMAT A6
SET colsep '|'
SET LINES 100
SELECT p.id,
    RPAD(' ',p.depth*2, ' ')||p.operation operation,
    p.object_name object,  p.cardinality card,p.cost cost,
    SUBSTR(m.status,1,4) status,
    m.output_rows
FROM v$SQL_PLAN p, V$SQL_PLAN_MONITOR m
WHERE p.sql_id=m.sql_id
  AND p.child_address=m.sql_child_address
  AND p.plan_hash_value=m.sql_plan_hash_value
  AND p.id=m.plan_line_id
  AND m.sql_id='dn87f27d1f0m0'
  AND m.sql_exec_id=16777217
  AND m.sql_exec_start=TO_DATE('20/05/2010 18:25:42','DD/MM/YYYY HH24:MI:SS')
ORDER BY p.id;

-- Vous pouvez rexcuter pour suivre l'volution de votre requte : /
