
CREATE TABLE Pilote
	(brevet VARCHAR(6), nom VARCHAR(20), dateNaiss DATE, dernierVol DATE,
	 dateEmbauche DATE, prochainVolControle DATE, nombreJoursNaisBoulot NUMBER,
	 intervalleNaisBoulot       INTERVAL DAY(7) TO SECOND(3), 
	 intervalleVolExterieur     INTERVAL DAY(2) TO SECOND(0),
	 intervalleEntreVols        INTERVAL DAY(2) TO SECOND(2),
	 intervalleEmbaucheControle INTERVAL DAY(2) TO SECOND(1),
	 compa VARCHAR(4), CONSTRAINT pk_Pilote PRIMARY KEY(brevet));

INSERT INTO Pilote
	VALUES ('PL-1', 'Thierry Albaric', '25-03-1967', '10-04-2003', SYSDATE, 
	TO_DATE('13-05-2003 15:30:00','DD:MM:YYYY HH24:MI:SS'), NULL, NULL, NULL, NULL, NULL, 'AF');

--et le thme astral...
UPDATE  Pilote
	SET dateNaiss = TO_DATE('25-03-1967 12:35:00', 'DD:MM:YYYY HH24:MI:SS') 
	WHERE brevet = 'PL-1';

SELECT nom, TO_CHAR(dateNaiss,'DD:MM:YYYY HH:MI:SS') FROM Pilote;

SELECT nom, TO_CHAR(dateEmbauche,'DD:MM:YYYY HH:MI:SS') FROM Pilote;

--revenez la semaine prochaine + 10minutes , on vous crira srement d'ici l
UPDATE  Pilote
	SET dateEmbauche = dateEmbauche+7+(10/(24*60))  WHERE brevet = 'PL-1';

SELECT nom, TO_CHAR(dateEmbauche,'DD:MM:YYYY HH:MI:SS') FROM Pilote;

SELECT dateEmbauche-dateNaiss FROM Pilote;

--Attendre avant la premire paye
UPDATE  Pilote
	SET nombreJoursNaisBoulot = dateEmbauche-dateNaiss WHERE brevet = 'PL-1';


SELECT nombreJoursNaisBoulot  FROM Pilote;

--au format intervalle

UPDATE  Pilote
	SET intervalleNaisBoulot = NUMTODSINTERVAL(dateEmbauche-dateNaiss,'DAY'),
             intervalleEntreVols = NUMTODSINTERVAL(prochainVolControle-dernierVol,'DAY'),
		intervalleVolExterieur =  NUMTODSINTERVAL(dateEmbauche-dernierVol,'DAY')
	 WHERE brevet = 'PL-1';

SELECT intervalleNaisBoulot FROM Pilote;

--au format intervalle entre vol

SELECT intervalleEntreVols FROM Pilote;


--intervalleVolExterieur     

SELECT intervalleVolExterieur FROM Pilote;

--intervalleEmbaucheControle     
UPDATE  Pilote
SET intervalleEmbaucheControle =   intervalleEntreVols - intervalleVolExterieur
	 WHERE brevet = 'PL-1';

SELECT intervalleEmbaucheControle FROM Pilote;

DROP TABLE Pilote;
