
CREATE TABLE Compagnie
	(comp CHAR(4), nrue NUMBER(3), rue CHAR(20), ville CHAR(15), nomComp CHAR(15),
 	CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

CREATE TABLE Avion
	(immat CHAR(6), typeAvion CHAR(15), nbhVol NUMBER(10,2), proprio CHAR(4),
	CONSTRAINT pk_Avion PRIMARY KEY(immat));

CREATE TABLE Affreter
	(compAff CHAR(4), immat CHAR(6), dateAff DATE, nbPax NUMBER(3));


INSERT INTO Compagnie
	VALUES ('AF', 124, 'Port Royal', 'Paris', 'Air France');
INSERT INTO Compagnie
   VALUES ('SING', 7, 'Camparols', 'Singapour', 'Singapore AL');

INSERT INTO Avion
   VALUES ('F-WTSS', 'Concorde', 6570, 'SING');

INSERT INTO Avion
   VALUES ('F-GAFU', 'A320', 3500, 'AF');

INSERT INTO Avion
   VALUES ('F-GLFS', 'TB-20', 2000, 'SING');
 

INSERT INTO Affreter
   VALUES ('AF', 'F-WTSS', '13-05-2003', 85);

INSERT INTO Affreter
   VALUES ('SING', 'F-GAFU', '05-02-2003', 155);


INSERT INTO Affreter
   VALUES ('AF', 'F-WTSS', '15-05-2003', 82);

--
ALTER TABLE Avion
	ADD (CONSTRAINT nn_proprio CHECK (proprio IS NOT NULL),
	CONSTRAINT fk_Avion_comp_Compag FOREIGN KEY(proprio) REFERENCES Compagnie(comp));

ALTER TABLE Affreter
	ADD (
	CONSTRAINT pk_Affreter PRIMARY KEY (compAff, immat, dateAff),
	CONSTRAINT fk_Aff_na_Avion FOREIGN KEY(immat) REFERENCES Avion(immat),
	CONSTRAINT fk_Aff_comp_Compag FOREIGN KEY(compAff) REFERENCES Compagnie(comp));

--suppression de contraintes

ALTER TABLE Avion
	DROP CONSTRAINT nn_proprio;

ALTER TABLE Avion
	DROP CONSTRAINT fk_Avion_comp_Compag;

ALTER TABLE Avion
	DROP CONSTRAINT pk_Avion ;

ALTER TABLE Avion
	DROP CONSTRAINT pk_Avion CASCADE;

INSERT INTO Affreter
   VALUES ('AF', 'toto', '15-05-2003', 82);
INSERT INTO Avion
   VALUES ('F-GLFS', 'bis', 2000, 'SING');
 
ALTER TABLE Affreter
	DROP CONSTRAINT fk_Aff_comp_Compag;

ALTER TABLE Compagnie
	DROP CONSTRAINT pk_Compagnie;

INSERT INTO Affreter
   VALUES ('titi', 'toto', '15-05-2003', 82);

ALTER TABLE Affreter
	DROP CONSTRAINT pk_Affreter;

INSERT INTO Affreter
   VALUES ('titi', 'toto', '15-05-2003', 82);

DROP TABLE Affreter;
DROP TABLE Avion;
DROP TABLE Compagnie;

--Dsactivation de contraintes

CREATE TABLE Compagnie
	(comp CHAR(4), nrue NUMBER(3), rue CHAR(20), ville CHAR(15), nomComp CHAR(15),
 	CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

CREATE TABLE Avion
	(immat CHAR(6), typeAvion CHAR(15), nbhVol NUMBER(10,2), proprio CHAR(4),
	CONSTRAINT nn_proprio CHECK (proprio IS NOT NULL),
	CONSTRAINT fk_Avion_comp_Compag FOREIGN KEY(proprio) REFERENCES Compagnie(comp),
	CONSTRAINT pk_Avion PRIMARY KEY(immat));

CREATE TABLE Affreter
	(compAff CHAR(4), immat CHAR(6), dateAff DATE, nbPax NUMBER(3),
	CONSTRAINT pk_Affreter PRIMARY KEY (compAff, immat, dateAff),
	CONSTRAINT fk_Aff_na_Avion FOREIGN KEY(immat) REFERENCES Avion(immat),
	CONSTRAINT fk_Aff_comp_Compag FOREIGN KEY(compAff) REFERENCES Compagnie(comp));

--
INSERT INTO Compagnie
	VALUES ('AF', 124, 'Port Royal', 'Paris', 'Air France');

INSERT INTO Compagnie
   VALUES ('SING', 7, 'Camparols', 'Singapour', 'Singapore AL');

INSERT INTO Avion
   VALUES ('F-WTSS', 'Concorde', 6570, 'SING');

INSERT INTO Affreter
   VALUES ('AF', 'F-WTSS', '13-05-2003', 85);

SELECT * FROM Compagnie;
SELECT * FROM Avion;
SELECT * FROM Affreter;


--1

ALTER TABLE Avion DISABLE CONSTRAINT nn_proprio;

INSERT INTO Avion
   VALUES ('Bidon1', 'TB-20', 2000, NULL);

--rollback;

--2
ALTER TABLE Avion DISABLE CONSTRAINT fk_Avion_comp_Compag;

INSERT INTO Avion
   VALUES ('F-GLFS', 'TB-22', 500, 'Toto');

--rollback;

--3

ALTER TABLE Avion DISABLE CONSTRAINT pk_Avion CASCADE DROP INDEX;

INSERT INTO Avion
   VALUES ('Bidon1', 'TB-21', 1000, 'AF');

INSERT INTO Affreter
   VALUES ('AF', 'Toto', '13-05-2003', 0);

--rollback;

--
SELECT * FROM Compagnie;
SELECT * FROM Avion;
SELECT * FROM Affreter;




--Ractivation de contraintes

--ALTER TABLE Avion ENABLE CONSTRAINT nn_proprio;

--ALTER TABLE Avion ENABLE 
--	CONSTRAINT pk_Avion	USING INDEX (CREATE UNIQUE INDEX pk_Avion ON Avion (immat));

DROP TABLE Problemes ;
CREATE TABLE Problemes 
	(adresse ROWID,   utilisateur VARCHAR2(30),   
	nomTable VARCHAR2(30),   nomContrainte VARCHAR2(30));

--1

ALTER TABLE Avion ENABLE CONSTRAINT nn_proprio EXCEPTIONS INTO Problemes;

SELECT adresse, nomContrainte, nomTable FROM Problemes;

SELECT a.ROWID, a.* FROM Avion a
 WHERE a.ROWID IN (SELECT adresse FROM Problemes);

--2
ALTER TABLE Avion ENABLE CONSTRAINT fk_Avion_comp_Compag 
	EXCEPTIONS INTO Problemes;

SELECT adresse, nomContrainte, nomTable FROM Problemes;

SELECT a.ROWID, a.* FROM Avion a
 WHERE a.ROWID IN (SELECT adresse FROM Problemes);


--3

ALTER TABLE Avion ENABLE 
	CONSTRAINT pk_Avion EXCEPTIONS INTO Problemes;

SELECT adresse, nomContrainte, nomTable FROM Problemes;

SELECT a.ROWID, a.* FROM Avion a
 WHERE a.ROWID IN (SELECT adresse FROM Problemes);

--Traiter les erreurs
--ractiver puis ractiver la dernire :

--3bis PB tq la PK n'est pas ractive!


UPDATE Avion SET immat = 'F-TB20'
	WHERE immat = 'Bidon1' AND typeAvion = 'TB-20';

UPDATE Avion SET proprio = 'AF'
	WHERE NOT(proprio = 'SING');

UPDATE Affreter SET immat = 'F-TB20' WHERE immat = 'Toto';

SELECT * FROM Compagnie;
SELECT * FROM Avion;
SELECT * FROM Affreter;

DELETE FROM Problemes ;


--1

ALTER TABLE Avion ENABLE CONSTRAINT nn_proprio EXCEPTIONS INTO Problemes;

SELECT adresse, nomContrainte, nomTable FROM Problemes;

SELECT a.ROWID, a.* FROM Avion a
 WHERE a.ROWID IN (SELECT adresse FROM Problemes);

--2
ALTER TABLE Avion ENABLE CONSTRAINT fk_Avion_comp_Compag 
	EXCEPTIONS INTO Problemes;

SELECT adresse, nomContrainte, nomTable FROM Problemes;

SELECT a.ROWID, a.* FROM Avion a
 WHERE a.ROWID IN (SELECT adresse FROM Problemes);


--3

ALTER TABLE Avion ENABLE 
	CONSTRAINT pk_Avion EXCEPTIONS INTO Problemes;

SELECT adresse, nomContrainte, nomTable FROM Problemes;

SELECT a.ROWID, a.* FROM Avion a
 WHERE a.ROWID IN (SELECT adresse FROM Problemes);

--3bis PB tq la PK n'est pas ractive!


ALTER TABLE Affreter 
	ENABLE CONSTRAINT fk_Aff_na_Avion EXCEPTIONS INTO Problemes;


SELECT adresse, nomContrainte, nomTable FROM Problemes;

SELECT a.ROWID, a.* FROM Affreter a
 WHERE a.ROWID IN (SELECT adresse FROM Problemes);


DROP TABLE Affreter;
DROP TABLE Avion;
DROP TABLE Compagnie;
