--

CREATE TABLE pilote
(brevet CHAR(8), nom CHAR(10), nbHVol INTEGER, 
adresse CHAR(20), compa CHAR(8),
CONSTRAINT pk_pilote PRIMARY KEY(brevet));
INSERT INTO pilote VALUES ('PL-1', 'Soutou', 890, 'Castanet', 'CAST');
INSERT INTO pilote VALUES ('PL-2', 'Laroche', 500, 'Montauban', 'CAST');
INSERT INTO pilote VALUES ('PL-3', 'Lamothe', 1200, 'Ramonville', 'AF');
INSERT INTO pilote VALUES ('PL-4', 'Albaric', 500, 'Vieille-Toulouse','AF');
INSERT INTO pilote VALUES ('PL-5', 'Bidal', 120, 'Paris', 'ASO');
INSERT INTO pilote VALUES ('PL-6', 'Labat', 120, 'Pau', 'ASO');
INSERT INTO pilote VALUES ('PL-7', 'Tauzin', 100, 'Bas-Mauco', 'ASO');

CREATE VIEW PilotesAF
    AS SELECT * FROM  Pilote 
    WHERE compa = 'AF';

CREATE VIEW Etat_civil
  AS SELECT nom, nbHVol, adresse, compa
  FROM Pilote;

SELECT SUM(nbHVol) FROM PilotesAF;

SELECT COUNT(*) FROM Etat_civil;

--Alias
CREATE OR REPLACE VIEW PilotesPasAF(codepil, nomPil, heuresPil, adressePil, socit)
  AS SELECT *
  FROM  Pilote
  WHERE NOT (compa = 'AF');

SELECT * FROM PilotesPasAF;

--
CREATE OR REPLACE VIEW PilotesPasAF
  AS SELECT brevet codepil, nom nomPil, nbHVol heuresPil, adresse adressePil, compa socit
  FROM  Pilote
  WHERE NOT (compa = 'AF');

SELECT * FROM PilotesPasAF;

--Read only
CREATE OR REPLACE VIEW PilotesPasAFRO
  AS SELECT *
  FROM  Pilote
  WHERE NOT (compa = 'AF')
  WITH READ ONLY;

INSERT INTO PilotesPasAFRO VALUES ('PL-8', 'Ferry', 5, 'Paris', 'ASO');

UPDATE PilotesPasAFRO SET nbHvol=nbHvol+2;

DELETE FROM PilotesPasAFRO ;

SELECT * FROM PilotesPasAFRO ;

--Vue d'une vue

CREATE OR REPLACE VIEW EtatCivilPilotesPasAF
  AS SELECT nomPil, heuresPil, adressePil
  FROM  PilotesPasAF;

SELECT * FROM EtatCivilPilotesPasAF;

--Mises  jour

INSERT INTO Etat_civil VALUES('Raffarin', 10, 'Poitiers', 'ASO');
DELETE FROM Etat_civil WHERE compa = 'ASO';
UPDATE Etat_civil
  SET nbHVol = nbHVol*2
  WHERE nom = 'Lamothe';

SELECT * FROM Etat_civil;
ROLLBACK;

INSERT INTO PilotesAF VALUES ('PL-8', 'Ferry', 5, 'Paris', 'AF');
UPDATE PilotesAF 
  SET nbHVol = nbHVol*2;
DELETE FROM PilotesAF WHERE nom = 'Ferry';
INSERT INTO PilotesAF VALUES ('PL-9', 'Raffarin', 10, 'Poitiers', 'ASO');

SELECT * FROM pilote;
SELECT * FROM PilotesAF;
ROLLBACK;

--
CREATE OR REPLACE VIEW PilotesAF
  AS SELECT * FROM  pilote
  WHERE compa = 'AF' WITH CHECK OPTION;

INSERT INTO PilotesAF VALUES ('PL-10', 'Jupp', 10, 'Bordeaux', 'ASO');
UPDATE PilotesAF SET compa='ASO';
INSERT INTO PilotesAF VALUES ('PL-11','Teste',900,'Revel','AF');
SELECT * FROM PilotesAF;
SELECT * FROM pilote;
ROLLBACK;

----contraintes in line
CREATE OR REPLACE VIEW PilotesPasAF_inLine
  (codepil, nomPil UNIQUE DISABLE NOVALIDATE, heuresPil, adressePil, socit)
  AS SELECT * FROM  Pilote
  WHERE NOT (compa = 'AF')
 WITH CHECK OPTION;

SELECT * FROM PilotesPasAF_inLine;
-passe!
INSERT INTO PilotesPasAF_inLine VALUES ('PL-10', 'Tauzin', 10, 'Bordeaux', 'ASO');
ROLLBACK;

----contraintes outline
CREATE OR REPLACE VIEW PilotesPasAF_outLine
  (codepil, nomPil, heuresPil, adressePil, socit,
   CONSTRAINT un_nomPil UNIQUE(nomPil) DISABLE NOVALIDATE)
  AS SELECT * FROM  Pilote
  WHERE NOT (compa = 'AF')
  WITH CHECK OPTION;
SELECT * FROM PilotesPasAF_outLine;

-passe!
INSERT INTO PilotesPasAF_outLine VALUES ('PL-10', 'Tauzin', 10, 'Bordeaux', 'ASO');
ROLLBACK;

--bug
ALTER VIEW PilotesPasAF_outLine
  ENABLE CONSTRAINT un_nomPil ;

--------------vues complexes
DROP TABLE Pilote;
CREATE TABLE Compagnie
	(comp CHAR(4), nrue NUMBER(3), 
	rue CHAR(20), ville CHAR(15) DEFAULT 'Paris', nomComp CHAR(15),
 	CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

CREATE TABLE Pilote
	(brevet CHAR(6), nom CHAR(15), nbHVol NUMBER(7,2), compa CHAR(4),
	 CONSTRAINT pk_Pilote PRIMARY KEY(brevet),
	 CONSTRAINT nn_nom    CHECK (nom IS NOT NULL),
	 CONSTRAINT ck_nbHVol CHECK (nbHVol BETWEEN 0 AND 20000),
	 CONSTRAINT un_nom    UNIQUE (nom),
	 CONSTRAINT fk_Pil_compa_Comp FOREIGN KEY(compa) REFERENCES Compagnie(comp));

INSERT INTO Compagnie VALUES ('SING', 7, 'Camparols', 'Singapour', 'Singapore AL');
INSERT INTO Compagnie VALUES ('AF', 124, 'Port Royal', DEFAULT, 'Air France');
INSERT INTO Pilote VALUES ('PL-1', 'Amlie Sulpice', 450, 'AF');
INSERT INTO Pilote VALUES ('PL-2', 'Thomas Sulpice', 900, 'AF');
INSERT INTO Pilote VALUES ('PL-3', 'Paul Soutou', 1000, 'SING');

--
CREATE VIEW Pilotes_multi_AF
        AS SELECT  p.brevet, p.nom, p.nbHVol, c.ville, c.nomComp
             FROM  Pilote p, Compagnie c
             WHERE p.compa = c.comp
             AND   p.compa = 'AF';
SELECT * FROM Pilotes_multi_AF;

--
CREATE VIEW Moyenne_Heures_Pil
  AS SELECT compa, AVG(nbHVol) moyenne 
  FROM Pilote GROUP BY compa;
SELECT * FROM  Moyenne_Heures_Pil;

--insert : bug
INSERT INTO Moyenne_Heures_Pil VALUES ('TAT',50);
--update: bug
UPDATE Moyenne_Heures_Pil SET moyenne = 10;
--delete: bug
DELETE FROM Moyenne_Heures_Pil;

--insert : bug
INSERT INTO Pilotes_multi_AF VALUES 
('PL-4', 'Test', 400, 'Castanet','Castanet Air Lines');

--update
--possible (key preserved)
SELECT * FROM Pilotes_multi_AF;
UPDATE Pilotes_multi_AF 
  SET nbHVol =  nbHVol * 2;
SELECT * FROM Pilotes_multi_AF;

--pas possible
UPDATE Pilotes_multi_AF 
  SET ville =  'Orly';
SELECT * FROM Pilotes_multi_AF;
SELECT * FROM Compagnie;
SELECT * FROM Pilote;

ROLLBACK;
--delete
DELETE FROM Pilotes_multi_AF;
SELECT * FROM Pilotes_multi_AF;
SELECT * FROM Pilote;
SELECT * FROM Compagnie;
ROLLBACK;

--key preserved : Pilote 
CREATE VIEW  Vue_Multi_Comp_Pil
  AS SELECT c.comp, c.nomComp, p.brevet, p.nom, p.nbHVol
  FROM  Pilote p, Compagnie c
  WHERE p.compa = c.comp;

SELECT * FROM Vue_Multi_Comp_Pil;

--pas possible
INSERT INTO Vue_Multi_Comp_Pil VALUES ('TAT', 'Test', 'PL-5', 'Jean',2500);
--ok
UPDATE Vue_Multi_Comp_Pil 
  SET nbHVol = nbHVol*3;
--bug
UPDATE Vue_Multi_Comp_Pil 
  SET  nomComp = 'Dupond';
SELECT * FROM Vue_Multi_Comp_Pil;
--
DELETE FROM Vue_Multi_Comp_Pil WHERE comp='AF';
SELECT * FROM Vue_Multi_Comp_Pil;
SELECT * FROM Pilote;
SELECT * FROM Compagnie;

---
SELECT COLUMN_NAME, INSERTABLE, UPDATABLE, DELETABLE
      FROM USER_UPDATABLE_COLUMNS
      WHERE TABLE_NAME = UPPER('Vue_Multi_Comp_Pil');

---
CREATE VIEW Pilotes_multi2_AF
        AS SELECT  p.brevet, p.nom, p.nbHVol, p.compa
             FROM  Pilote p, Compagnie c
             WHERE p.compa = c.comp
             AND   c.nomComp = 'Air France';
SELECT * FROM Pilotes_multi_AF;

--insert 
INSERT INTO Pilotes_multi2_AF VALUES ('PL-4', 'Test', 400,'AF');

--
CREATE OR REPLACE VIEW Pilotes_multi2_AF
        AS SELECT  p.brevet, p.nom, p.nbHVol, p.compa
             FROM  Pilote p, Compagnie c
             WHERE p.compa = c.comp
             AND   c.nomComp = 'Air France'
	WITH CHECK OPTION;

SELECT * FROM Pilotes_multi_AF;
--insert :bug 
INSERT INTO Pilotes_multi2_AF VALUES ('PL-5', 'Test2', 400,'AF');
--possible
UPDATE Pilotes_multi_AF
  SET nbHVol = nbHVol*3;
SELECT * FROM Pilotes_multi_AF;

DELETE FROM Pilotes_multi_AF;
SELECT * FROM Pilotes_multi_AF;
ROLLBACK;

--
DROP TABLE Pilote;
DROP TABLE Compagnie;

CREATE TABLE Compagnie
	(comp CHAR(4), nrue NUMBER(3), 
	rue CHAR(20), ville CHAR(15), nomComp CHAR(15),
 	CONSTRAINT pk_Compagnie PRIMARY KEY(comp));
CREATE TABLE Pilote
	(brevet CHAR(6), nom CHAR(15), nbHVol NUMBER(7,2), compa CHAR(4),
	 CONSTRAINT pk_Pilote PRIMARY KEY(brevet));

--cohrence fils->pre
CREATE VIEW VueDesPilotes
	AS SELECT * FROM Pilote
	WHERE compa IN (SELECT comp FROM Compagnie) OR compa IS NULL
	WITH CHECK OPTION ;

--cohrence pre->fils
CREATE VIEW VueDesCompagnies
	AS SELECT * FROM Compagnie c
	WHERE NOT EXISTS (SELECT brevet FROM Pilote WHERE compa=c.comp);

--
INSERT INTO VueDesCompagnies VALUES ('SING', 7, 'Camparols', 'Singapour', 'Singapore AL');
INSERT INTO VueDesCompagnies VALUES ('AF', 124, 'Port Royal', 'Paris', 'Air France');
INSERT INTO VueDesPilotes VALUES ('PL-1', 'Pierre De Luca', 450, 'AF');
INSERT INTO VueDesPilotes VALUES ('PL-2', 'Yohan Delort', 900, 'AF');
INSERT INTO VueDesPilotes VALUES ('PL-3', 'Daniel Vielle', 1000, 'SING');

--cohrence fils->pre
INSERT INTO VueDesPilotes VALUES ('PL-4', 'Qui a?', 1000, 'Rien');
--OK
INSERT INTO VueDesPilotes VALUES ('PL-4', 'Paul Soutou', 1000, NULL);
INSERT INTO VueDesPilotes VALUES ('PL-5', 'Oliver Blanc', 500, 'SING');
--bug
UPDATE VueDesPilotes SET compa = 'Toto' WHERE brevet = 'PL-4';
--ok
UPDATE VueDesPilotes SET compa = 'AF' WHERE brevet = 'PL-4';

SELECT * FROM VueDesPilotes;
SELECT * FROM Pilote;

--cohrence pre->fils
INSERT INTO VueDesCompagnies VALUES ('EASY', 1, 'G. Brassens', 'Blagnac', 'Easy Jet');
--bug
UPDATE VueDesCompagnies SET comp = 'AF2' WHERE comp = 'AF';
--ok
UPDATE VueDesCompagnies SET ville = 'Perpignan' WHERE comp = 'EASY';
UPDATE VueDesCompagnies SET comp = 'EJET' WHERE comp = 'EASY';
--ok 
DELETE FROM VueDesCompagnies WHERE comp = 'EJET';
--bug
DELETE FROM VueDesCompagnies  WHERE comp = 'AF';

SELECT * FROM VueDesCompagnies ;

SELECT * FROM Compagnie;
SELECT * FROM Pilote;

---Confidentialit
CREATE VIEW VueDesCompagniesJoursFris
  AS SELECT * FROM Compagnie
  WHERE TO_CHAR(SYSDATE,'DAY') IN ('SAMEDI', 'DIMANCHE');
SELECT * FROM VueDesCompagniesJoursFris;
INSERT INTO VueDesCompagniesJoursFris 
 VALUES ('TEMP', 1, 'tmp', 'tmp', 'tmp...');

CREATE VIEW VueDesPilotesJoursOuvrables
  AS SELECT * FROM Pilote
  WHERE TO_CHAR(SYSDATE,'HH24:MI') BETWEEN '8:30' AND '17:30'
  AND TO_CHAR(SYSDATE,'DAY') NOT IN ('SAMEDI', 'DIMANCHE')
  WITH CHECK OPTION;
SELECT * FROM VueDesPilotesJoursOuvrables;
INSERT INTO VueDesPilotesJoursOuvrables
 VALUES ('PL-6', 'Pil nouveau', 50, 'SING');

DROP VIEW VueDesCompagniesJoursFris;
DROP VIEW VueDesPilotesJoursOuvrables;
DROP VIEW VueDesPilotes;
DROP VIEW VueDesCompagnies;

DROP VIEW Soutou_Camparols_PilotesAF;
DROP VIEW  Pilotes_multi_AF;

DROP VIEW  Moyenne_Heures_Pil;

DROP VIEW  Pilotes_multi2_AF;
DROP VIEW  Vue_Multi_Comp_Pil;
DROP VIEW EtatCivilPilotesPasAF;
DROP VIEW PilotesPasAF_outLine;
DROP VIEW PilotesPasAF_inLine;
DROP VIEW Etat_civil;
DROP VIEW PilotesAF;
DROP VIEW PilotesPasAF;
DROP TABLE pilote;
