
<?
//
// Programmation Web avec PHP, Code XI-1: Composant final d'accs aux bases de donnes
//
Class CBase
{
	# Proprits
	Var $TAB_Name = "";
	Var $Arr_Cols = Array();
	Var $SQL_CnxDsn = "";
	Var $SQL_CnxUsr = "";
	Var $SQL_CnxPwd = "";
	Var $SQL_SrvTyp = "ORACLE";		# Par dfaut, Oracle
	Var $STR_Del = "'";				# Par dfaut, la Quote
	Var $DAT_Fmt = "DD/MM/YYYY";		# Par dfaut, franais
	Var $FCT_CnvDat = "TO_Date";		# Celle d'Oracle
	#
	# Mthodes
	#
	# Fonction de connexion / dconnexion  la base Oracle par ODBC
	Function DoConnect( $bConnect, $sql_cnx )
	{
		# Connexion (ODBC, ou autre !)
		if ( $bConnect ) {
			$sql_cnx = odbc_connect( $SQL_CnxDsn, $SQL_CnxUsr, $SQL_CnxPwd );
			if ( ! $sql_cnx )	{
				$ErrMsg = "<B>Erreur de connexion  Oracle par ODBC.</B>\n";
				return False;
			}
			return $sql_cnx; 		# Connexion OK
		}
		# Dconnexion (ODBC, ou autre !)
		else {
			$sql_cnx = odbc_close( $sql_cnx );
			if ( ! $sql_cnx ) {
				$ErrMsg = "<B>Erreur de dconnexion  Oracle par ODBC.</B>\n";
				return False;
			}
			return True; 		# Dconnexion OK
		}
	} // DoConnect
	#
	# Excution d'une requte SQL, sur une base de donnes Oracle, par ODBC
	Function Exec_SqlProc( $SQLString )		# Version 3
	{
		$sql_cnx = false; $sql_res = false; $ErrMsg = "";	# (Sur une ligne)
		# Connexion
		if ( ! ( $sql_cnx = DoConnect( True, 0 ) ) ) return False;
		# Excution commande SQL
		if ( ! ( $sql_res = odbc_exec( $sql_cnx, $SQLString ) ) ) {
			$ErrMsg = "Erreur d'execution commande SQL:<P>".$SQLString."<P>\n";
			DoConnect( False, $sql_cnx );		# Dconnexion
			return False;
		}
		# Dconnexion ODBC
		if ( ! DoConnect( False, $sql_cnx ) ) return False;
		return True;
	} // Exec_SLQProc
	#
	# Excution d'une requte SQL Select ramenant une seule ligne de la base
	Function Exec_SqlOne( $SQL_CnxDsn, $SQL_CnxUsr, $SQL_CnxPwd, $SQLString )
	{
		$sql_cnx = false; $sql_res = false;
		# Connexion
		if ( ! ( $sql_cnx = DoConnect( True, 0 ) ) ) return False;
		# Excution commande SQL
		if ( ! ( $sql_id = odbc_exec( $sql_cnx, $SQLString ) ) ) {
			# Excution rate
			$ErrMsg =  "Erreur lors de l'execution de la commande: $SQLString";
			DoConnect( False, $sql_cnx );
			return False;
		}
		# Excution russie, rcuprer la ligne
		$arr_res = array();
		if ( odbc_fetch_into( $sql_id, 1, &$arr_res ) ) {
				$sql_res = "";
				while( list( $k, $v ) = each( $arr_res ) ) {
					$col_name = StrToLower( odbc_field_name( $sql_id, $k+1 ) );
					$sql_res .= "&$col_name=$v";
				}
			# Excution russie mais aucune ligne ramene
			} else {
				$sql_res =  "Aucune donne trouve";
			}
		}
		# Dconnexion ODBC
		DoConnect( False );
		}
		return $sql_res;
	} // Exec_SLQOne
}
?>
